# -*- coding: utf-8 -*-

import lxml.etree as et

def print_et(s):
    print(et.tostring(et.XML(et.tostring(s, encoding='utf-8'), parser=et.XMLParser(remove_blank_text=True)),
                      pretty_print=True,
                      encoding='utf-8',
                      ))

def printxml(s):
    print(et.tostring(et.XML(s, parser=et.XMLParser(remove_blank_text=True)),
                      pretty_print=True,
                      encoding='utf-8',
                      ))

def LOC():
    '''Возвращает строку с данными места вызова LOC(): файл, функцию и номер строки.'''
    import inspect
    _, caller_filename, caller_linenr, caller_funcname, _, _ = inspect.stack()[1]
    return "%s.%s():%s" % (caller_filename, caller_funcname, caller_linenr)

import sys, traceback

def format_exception_first_line():
    '''Форматирует исключение так, чтобы ошибка повторялась и на первой строке.
    Для удобства разбора логов ошибок.
    '''
    type, value, _ = sys.exc_info()
    return '%s; %s' % (traceback.format_exception_only(type, value)[-1].strip(),
                      traceback.format_exc()
                      )
