# -*- coding: utf-8 -*-
'''
Интерфейс к шаблонизатору friends.yandex.ru/mail
'''

from urllib.parse import urlencode
from httplib2 import Http

from .odict import odict
from . import encoding

# TODO: вынести в конфигурацию
APP_URL = 'http://friends.yandex.net/mail/notificationapi_app.xml'
USER_URL = 'http://friends.yandex.net/mail/notificationapi_user.xml'
#APP_URL = 'http://veged.widgets.leela.yandex.ru/mail/notificationapi_app.xml'
#USER_URL = 'http://veged.widgets.leela.yandex.ru/mail/notificationapi_user.xml'
DEFAULT_ACTION = 'Подробнее'

request = Http().request

class TemplateError(Exception):
    pass

# TODO: документация из wiki
def template(app_name, recipient_id, title, href, subject=None, body=None, action=None,
        href_action=None, sender_id=None):

    data = odict(
        app_name=app_name,
        dst_id=recipient_id,
        title=title,
        href=href,
        subject=subject or title,
        action=action or DEFAULT_ACTION,
        href_action=href_action or href,
    )

    if data.dst_id is None:
        raise ValueError(
                'Неправильный или несуществующий пользователь "%s"' % recipient_id)

    if sender_id is not None:
        data.by_user_id = sender_id
        if data.by_user_id is None:
            raise ValueError(
                    'Неправильный или несуществующий пользователь "%s"' % sender_id)

    if body is not None:
        data.additional_html = body

    url = (sender_id is None) and APP_URL or USER_URL

    data = dict([(key, encoding.force_str(value)) for key, value in list(data.items())])

    response, content = request(url, method="POST", body=urlencode(data))

    if response.status != 200:
        raise TemplateError('%s: %s' % (response.reason, content))

    return content
