# coding: utf-8


import operator

from at.common import utils
from at.common import dbswitch
from at.common import feed_weight_counter
from at.common.groups import GroupType
from at.common.utils import get_connection


class ClubsSuggest:
    @utils.log_exception
    def GetClubsSuggest(self, ai, part, count):
        part = utils.force_unicode(part).lower()
        return utils.build_xml(
            ("clubs", [
                ("club", [
                    ("title", club['title']),
                    ("title_eng", club['title_eng']),
                    ("feed_id", club['feed_id'])
                ])
                    for club in _get_club_suggest(ai, part, count)
                ]
             )
        )

    @utils.log_exception
    def GetDefaultClubsSuggest(self, ai, count):
        top_n_clubs = feed_weight_counter.FeedWeightCounter(ai.uid).get_top_n(count)
        return utils.build_xml(("default_clubs", [
            ("club", [
                ("feed_id", feed_id)
            ])
         for feed_id in top_n_clubs]))


def _count_matches(club, part):
    matches_count = 0
    matched_fields = ('login', 'title', 'title_eng')
    for field in matched_fields:
        if part in utils.force_unicode(club[field]).lower():
            matches_count += 1
    return matches_count


def _get_club_suggest(ai, part, count):
    clubs = _get_user_clubs(ai.uid)
    matched_clubs = []
    for club in clubs:
        matches_count = _count_matches(club, part)
        if matches_count:
            matched_clubs.append({'club': club, 'matches_count': matches_count})

    matched_clubs.sort(key=operator.itemgetter('matches_count'))
    return [matched_club['club'] for matched_club in matched_clubs][:count]


def _get_user_clubs(uid):
    sql = """
SELECT p.person_id, p.title, p.title_eng, p.login
  FROM persons p
  JOIN FriendGroupMember fgm ON (
      fgm.uid = :uid
      AND fgm.fgroup_id >= :role_id
      AND fgm.fgroup_id < 100
      AND fgm.person_id = p.person_id
  )
  WHERE
    p.status = 'normal'
"""
    result = get_connection().execute(
            sql,
            {
                'uid': uid,
                'role_id': GroupType.MEMBER,
            }
        )

    return [
        {
            'feed_id': feed_id,
            'title': title,
            'title_eng': title_eng,
            'login': login,
        }
        for (feed_id, title, title_eng, login) in result.fetchall()
    ]
