# *-* encoding: utf-8 *-*

from at.common.item_loader import per_item_loader


def get_like_counts(ids):
    loaded = per_item_loader(
        ids=ids,
        fields=['feed_id', 'item_no', 'comment_id'],
        query='SELECT feed_id, item_no, comment_id, count(*), sum(value) ' \
              'FROM Likes WHERE %s GROUP BY feed_id, item_no, comment_id'
    )
    for id in ids:
        if id not in loaded:
            loaded[id] = (0, 0)
    return loaded
