# -*- coding: utf-8 -*-



import logging

from lxml import etree as ET

from at.common import dbswitch
from at.common import utils

from at.common.groups import GroupType
from at.aux_ import models
from at.aux_ import Accesses
from at.aux_ import Relations
from at.aux_ import Friends


_log = logging.getLogger(__name__)


class Moderation:
    @utils.et2xml
    @utils.log_exception
    def BanPerson(self, ai, request):
        feed_id = request['feed_id']
        uid = request['uid']
        with dbswitch.root_rw_session():
            Friends.banPerson(ai, uid, feed_id)
        return utils.Status('OK')


    @utils.et2xml
    @utils.check_auth (1)
    def UnbanPersonsBulc(self, ai, request):
        feed_id = request['feed_id']
        uids = list(map(int, request.get('uids').split(',')))

        with dbswitch.root_rw_session():
            for uid in uids:
                try:
                    Friends.unbanPerson(ai, uid, feed_id)
                except Exception as e:
                    _log.warning('%s not unbanned: %s', uid, e)
        return utils.Status("OK")


    @utils.et2xml
    @utils.log_exception
    def GetBannedPersons(self, ai, feed_id, page, count):
        access = Accesses.Access(ai.uid, feed_id)
        access.assert_can_get_friendlist()
        relations = Relations.list_feed_relations(feed_id, [GroupType.BANNED],
                    count=count, page=page)
        root = relations.to_xml('banned-persons', 'banned')
        root.attrib.update({
            'total': str(Relations.get_total_relations_counters(feed_id, GroupType.BANNED)[GroupType.BANNED]),
            'page': str(page),
            'page_size': str(count),
            })
        return ET.ElementTree(root)


def add_moderator(club_slug, login):
    person = models.Person.objects.get(login=login, user_type=models.Person.PROFILE)
    club = models.Person.objects.get(login=club_slug, user_type=models.Person.COMMUNITY)
    return models.Friend.objects.create(
        uid=person,
        person_id=club,
        fgroup_id=GroupType.MODERATOR,
    )
