# -*- coding: utf-8 -*-



import datetime as dt
import logging
import time

import lxml.etree as ET

from django.conf import settings
from at.common import dbswitch
from at.common import utils

_log = logging.getLogger('aux')

BIRTHDAYS_LOOKUP_DAYS = 3


def wrap_aux(et):
    root_node = et.getroot()
    new_root_node = root_node
    if root_node.tag != "aux":
        new_root_node = ET.Element("aux")
        new_root_node.append(root_node)

    return root_node


def get_dates():
    today = dt.datetime.today()
    dates = []
    for i in range(BIRTHDAYS_LOOKUP_DAYS):
        dates.append((today + dt.timedelta(i)).strftime('"%m-%d"'))
    if '"02-28"' in dates:
        dates.append('"02-29"')
    return ','.join(dates)


def _getCurrentBirthdays(ai):
    root = ET.Element('birthdays')
    sql = """
        SELECT bday.bday, bday.person_id
        FROM
          Followers flw
          JOIN persons p USING (person_id)
          JOIN bday USING (person_id)
        WHERE
            flw.uid=%s
            AND p.status = 'normal'
            AND person_id < %s
            AND bday IN (%s)
    """ % (ai.uid, settings.COMMUNITY_START_ID, get_dates())
    bdays = {}
    with utils.get_connection() as connection:
        cursor = connection.execute(sql)
        for row in cursor:
            bdays[row[0]] = bdays.get(row[0], []) + [row[1]]
    dates = []
    today = dt.date.today()
    for day in list(bdays.keys()):
        try:
            m, d = [int(i) for i in day.split('-')]
            add_year = int(today.month == 12 and day.startswith('01'))
            dates.append(dt.date(today.year + add_year, m, d))
        except:
            _log.error('Unexpected BIRTHDAY: %s' % day)
            continue
    for day in sorted(dates):
        day_node = ET.SubElement(root, 'day', {
            'timestamp': str(int(time.mktime(day.timetuple())))})
        for uid in bdays[day.strftime('%m-%d')]:
            ET.SubElement(day_node, 'uid').text = str(uid)
    return ET.ElementTree(root)

# vim: et ts=4 sts=4 sw=4
