# -*- coding: utf-8 -*-



import logging

import lxml.etree as ET

from at.common.utils import Status, log_exception, stopwatch
from at.common import Rubrics


_log = logging.getLogger('aux')


def _person_to_xml(person_tuple,tag='person', default_pictures = None):
    p_el = ET.Element(tag)
    if not default_pictures:
        default_pictures = {}

    fields = ('id', 'login', 'title', 'sex', 'picture', 'status', 'qu_up_time','type', 'default_picture', 'metatype')
    conv_funcs = (str,str,lambda x:str(x,'utf-8'),str,str,str,str,str, lambda x: default_pictures.get(person_tuple[0], ''), str)
    for tag,val,conv in zip(fields,person_tuple+('', 'personal',),conv_funcs):
        el = ET.SubElement(p_el, tag)
        el.text = conv(val)

    return p_el


class Statistics:

    @log_exception
    @stopwatch
    def SetPostRubric(self, ai, request):
        feed_id = request['feed_id']
        item_no = request['item_no']
        rubric = request['rubric']
        _log.info('%s moved %d.%d to rubric "%s"' % (ai.login, feed_id, item_no, rubric))
        rubric_id = Rubrics.Rubrics().by_metarubric(rubric).rubric_id
        Rubrics.set_rubric(feed_id, item_no, rubric_id)
        return Status('OK')
