# coding: utf-8

import datetime

from at.common import exceptions


def is_a(check_type):
    def checker(obj):
        if obj and not isinstance(obj, check_type):
            raise exceptions.InvalidParams("'%s' must be %s, not %s" %
                                  (obj, check_type, type(obj)))

    return checker


class Field(object):
    default_validators = []

    def __init__(self, validators=None, **options):
        self.validators = validators or []
        self.validators.extend(self.default_validators)
        self.options = options

    def validate(self, value):
        for func in self.validators:
            func(value)


class DatetimeField(Field):
    default_validators = [is_a(datetime.datetime)]


class DateField(DatetimeField):
    default_validators = [is_a(datetime.date)]


class IntegerField(Field):
    default_validators = [is_a(int)]


class BooleanField(Field):
    default_validators = [is_a(bool)]


class StringField(Field):
    default_validators = [is_a((str, bytes))]


class ListField(Field):
    default_validators = [is_a(list)]
