# coding: utf-8

from at.common import utils
from at.common import assertions
from at.common import wf


BODY_LIMIT = (2 ** 10) * 150


class WikiFormatter(object):

    def format_title(self, value):
        return utils.force_unicode(value)

    def format_body(self, value):
        assertions.assertion(
            len(utils.force_unicode(value)) <= BODY_LIMIT,
            'body', 'NOT_VALID', 'post'
        )
        return wf.convert_to_html(value)
