# coding: utf-8


class BaseRepository(object):

    def get_entry_cls(self, entry_type):
        from at.aux_.entries import models
        return models.get_post_class(entry_type)

    def load(self, feed_id, item_no, comment_id=0):
        raise NotImplementedError

    def save(self, entry):
        raise NotImplementedError

    def delete(self, entry, manually=True):
        entry.mark_deleted(manually=manually)
