# coding: utf-8
import time
import datetime

from at.common import utils
from ... import fields


def datetime_to_xml_literal(_, value):
    return str(utils.dt2timestamp(value))


def date_to_xml_literal(_, value):
    return time.strftime('%Y-%m-%d', value.timetuple())


def integer_to_xml_literal(field, value):
    if field.options.get('serialize_as_bool'):
        return boolean_to_xml_literal(field, value)
    return str(value)


def boolean_to_xml_literal(field, value):
    if field.options.get('integer'):
        return str(int(value))
    else:
        # если поле есть и True --> пишем 'true', иначе нет ноды
        return value and 'true' or None


def string_to_xml_literal(_, value):
    return utils.force_unicode(value)


def xml_to_datetime(_, value):
    if not value:
        return None
    return datetime.datetime.fromtimestamp(int(value))


def xml_to_date(_, value):
    if not value:
        return None
    return utils.parse_date(value)


def xml_to_integer(_, value):
    return int(value)


def xml_to_boolean(field, value):
    if field.options.get('integer'):
        return bool(int(value))
    return {'false': False, 'true': True}.get(value, False)


def xml_to_string(_, value):
    return utils.force_unicode(value)


def to_literal(field, obj_value):
    return {
        fields.DatetimeField: datetime_to_xml_literal,
        fields.DateField: date_to_xml_literal,
        fields.BooleanField: boolean_to_xml_literal,
        fields.StringField: string_to_xml_literal,
        fields.IntegerField: integer_to_xml_literal
    }[field.__class__](field, obj_value)


def from_literal(field, value):
    value = value or ''
    return {
        fields.DatetimeField: xml_to_datetime,
        fields.DateField: xml_to_date,
        fields.BooleanField: xml_to_boolean,
        fields.StringField: xml_to_string,
        fields.IntegerField: xml_to_integer
    }[field.__class__](field, value)
