# coding: utf-8

import logging

from at.common import Types
from at.aux_.feeds import loaders


logger = logging.getLogger(__name__)


class CalendarLoader(loaders.PostsLoader):

    order = 'store_time_month_year'

    defaults = {
        'tag_id': None,
        'post_types': list,
    }

    select_fields = (
        'store_time_month_year',
        'COUNT(*) as posts_count',
    )

    def __init__(self, viewer_id, feed_id, **params):
        self.feed_id = feed_id
        super(CalendarLoader, self).__init__(viewer_id, **params)

    def get_query_args(self):
        args = super(CalendarLoader, self).get_query_args()
        args['feed_id'] = self.feed_id

        if self.tag_id:
            args['tag_id'] = self.tag_id
        return args

    def get_from_lines(self):
        lines = [
            'FROM Posts',
            self.ACCESS_JOIN,
        ]
        if self.tag_id:
            lines.append("""
                LEFT JOIN `PostCategories` tags ON (
                    Posts.person_id = tags.feed_id AND
                    Posts.post_no = tags.post_no
                )
            """)
        return lines

    def get_where_lines(self):
        lines = [
            'WHERE Posts.person_id=%(feed_id)s',
            self.ACCESS_CONDITION,
        ]

        if self.post_types:
            lines.append('AND post_type IN (%s)' % ', '.join([
                str(Types.ItemTypes().by_name(post_type_name)['id'])
                for post_type_name in self.post_types
            ]))

        if self.tag_id:
            lines.append('AND tags.cat_id = %(tag_id)s')
        return lines

    def get_group_by_lines(self):
        return [
            'GROUP BY store_time_month_year'
        ]
