# coding: utf-8
import logging
import itertools

from at.common import utils, dbswitch
from at.aux_ import entries
from at.aux_.entries.repositories.mysql_repository import MysqlRepository


logger = logging.getLogger(__name__)


def get_root_comments(feed_id, item_no, last_seen_id=None, count=100):
    if count <= 0:
        return [] # на всякий случай
    condition = 'c.person_id=%s AND c.post_no=%s AND c.parent_id=0 AND c.comment_id > %s' % \
                (feed_id, item_no, last_seen_id or 0)
    accumulator = 0
    comments = []
    next_comment_id = None
    extra_count = 0
    entry_iter = entries.models.load_comments_by_condition(condition)
    for entry in entry_iter:
        if accumulator < count:
            comments.append(entry)
            accumulator += 1 + entry.children_count # сам коммент и его дети
        if accumulator >= count:
            next_comment_id = entry.comment_id
            break
    for entry in entry_iter: # хвост
        extra_count += 1 + entry.children_count
    if not extra_count:
        next_comment_id = None
    return comments, next_comment_id, extra_count


def get_children_comments(feed_id, item_no, parent_ids):
    # Важно, чтоб parent_ids всегда были одного уровня! (по идее – первого) А то будет по нескольку вхождений
    # в CFP для одного коммента, и появятся дубли.
    if not parent_ids:
        return []
    condition = 'c.person_id=%s AND c.post_no=%s AND cp.parent_id IN (%s)' \
        % (feed_id, item_no, ','.join(str(parent_id) for parent_id in parent_ids))
    join_tables = 'JOIN CommentsFullParents cp USING (person_id, post_no, comment_id) '
    return list(entries.models.load_comments_by_condition(condition=condition, join_tables=join_tables))


def build_comment_tree(root, _from, limit):
    feed_id, item_no, parent_id = root.feed_id, root.item_no, root.comment_id
    with utils.get_connection():
        if not parent_id:
            parents, last_comment_id, extra_count = \
                get_root_comments(feed_id, item_no, _from, limit)
        else:
            parents, last_comment_id, extra_count = [root], None, 0
        children = get_children_comments(feed_id, item_no, [p.comment_id for p in parents])
        id_map = dict((c.comment_id, c) for c in itertools.chain(parents, children))

        # загрузить ChildrenCount для трекбэков:
        mapping = dict(
            ((c.tb_feed_id, c.tb_item_no), c.comment_id) for c in id_map.values()
            if c.tb_feed_id
        )
        for comment_id, children_count in MysqlRepository.get_trackback_children_count(mapping):
            id_map[comment_id].children_count = children_count

    for c in children:
        try:
            id_map[c.parent_comment_id].children_comments.append(c)
        except KeyError:
            logger.exception('(%s, %s, %s) from children without parent %s', c.feed_id, c.item_no, c.comment_id, c.parent_comment_id)
            raise
    return parents, last_comment_id, extra_count



