# coding: utf-8

import logging

from at.aux_.feeds import loaders
from at.common import utils

logger = logging.getLogger(__name__)


class FriendsPostsLoader(loaders.PostsLoader):

    pager_type = 'timestamp'

    select_fields = (
        'Posts.person_id',
        'Posts.post_no',
        'Posts.store_time',
        'Posts.store_time_usec',
    )

    direction = '<'

    defaults = {
        'limit': None,
        'tb': utils.usec,
        'order': 'store_time',
    }

    def get_query_args(self):
        args = super(FriendsPostsLoader, self).get_query_args()
        args['host_id'] = self.host_id
        if self.tb:
            args['tb'] = self.tb
        return args

    def get_from_lines(self):
        return [
            'FROM Followers flw',
            'JOIN Posts USE INDEX(store_time) USING(person_id)',
            'JOIN persons p USING(person_id)',
            self.ACCESS_JOIN,
        ]

    def get_where_lines(self):
        return [
            "WHERE p.status != 'deleted'",
            "AND flw.uid=%(host_id)s",
            "AND Posts.store_time_usec", self.direction, "%(tb)s",
            self.ACCESS_CONDITION,
        ]
