# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2018-03-13 08:03


from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Follower',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'db_table': 'Followers',
            },
        ),
        migrations.CreateModel(
            name='Friend',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fgroup_id', models.IntegerField(default=10)),
                ('add_date', models.DateTimeField(default=django.utils.timezone.now)),
                ('mutually', models.IntegerField(default=0)),
            ],
            options={
                'db_table': 'FriendGroupMember',
            },
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('person_id', models.IntegerField(primary_key=True, serialize=False)),
                ('login', models.CharField(default='', max_length=255)),
                ('title', models.CharField(db_index=True, default='', max_length=255)),
                ('title_eng', models.CharField(default='', max_length=255)),
                ('picture_html', models.CharField(default='', max_length=255)),
                ('description', models.TextField(default='', max_length=255)),
                ('creation_date', models.DateTimeField(default=django.utils.timezone.now)),
                ('modification_date', models.DateTimeField(default=django.utils.timezone.now)),
                ('user_type', models.CharField(choices=[('community', 'community'), ('profile', 'profile')], default='profile', max_length=255)),
                ('status', models.CharField(choices=[('normal', 'normal'), ('memorial', 'memorial'), ('deleted', 'deleted'), ('dismissed', 'dismissed')], default='normal', max_length=255)),
                ('sex', models.CharField(choices=[('man', 'man'), ('woman', 'woman'), ('unknown', 'unknown')], default='man', max_length=255)),
                ('mood', models.CharField(default='', max_length=255)),
                ('qu', models.IntegerField(default=1)),
                ('qu_up_time', models.DateTimeField(default='1970-01-01 00:00:00+0000')),
                ('bd_year', models.SmallIntegerField(default=0)),
                ('bd_month', models.SmallIntegerField(default=0)),
                ('bd_day', models.SmallIntegerField(default=0)),
                ('score', models.IntegerField(default=0)),
                ('email', models.CharField(default='', max_length=255)),
                ('community_type', models.CharField(choices=[('OPENED_COMMUNITY', 'OPENED_COMMUNITY'), ('PREMODERATED_COMMUNITY', 'PREMODERATED_COMMUNITY'), ('CLOSED_COMMUNITY', 'CLOSED_COMMUNITY'), ('PREMODERATED_CLOSED_COMMUNITY', 'PREMODERATED_CLOSED_COMMUNITY'), ('NONE', 'NONE')], max_length=255)),
                ('has_access', models.BooleanField(default=False)),
            ],
            options={
                'db_table': 'persons',
            },
        ),
        migrations.AddField(
            model_name='friend',
            name='person_id',
            field=models.ForeignKey(db_column='person_id', on_delete=django.db.models.deletion.CASCADE, related_name='friend_by', to='aux_.Person'),
        ),
        migrations.AddField(
            model_name='friend',
            name='uid',
            field=models.ForeignKey(db_column='uid', on_delete=django.db.models.deletion.CASCADE, related_name='friends', to='aux_.Person'),
        ),
        migrations.AddField(
            model_name='follower',
            name='person_id',
            field=models.ForeignKey(db_column='person_id', on_delete=django.db.models.deletion.CASCADE, related_name='followers', to='aux_.Person'),
        ),
        migrations.AddField(
            model_name='follower',
            name='uid',
            field=models.ForeignKey(db_column='uid', on_delete=django.db.models.deletion.CASCADE, related_name='follow_on', to='aux_.Person'),
        ),
        migrations.AlterUniqueTogether(
            name='follower',
            unique_together=set([('uid', 'person_id')]),
        ),
    ]
