DELETE FROM Followers WHERE
  (
    uid IN (
        SELECT fuid FROM (
          SELECT DISTINCT flw.uid AS fuid
          FROM Followers AS flw LEFT JOIN persons ON flw.uid = persons.person_id
          WHERE persons.person_id IS NULL
        ) AS b
    )
    OR person_id IN(
        SELECT fpid FROM (
          SELECT DISTINCT flw.person_id AS fpid
          FROM Followers AS flw LEFT JOIN persons ON flw.person_id = persons.person_id
          WHERE persons.person_id IS NULL
      ) AS c
    )
  );

DELETE FROM FriendGroupMember WHERE
  (
    uid IN (
        SELECT fuid FROM (
          SELECT DISTINCT flw.uid AS fuid
          FROM FriendGroupMember AS flw LEFT JOIN persons ON flw.uid = persons.person_id
          WHERE persons.person_id IS NULL
        ) AS b
    )
    OR person_id IN(
        SELECT fpid FROM (
          SELECT DISTINCT flw.person_id AS fpid
          FROM FriendGroupMember AS flw LEFT JOIN persons ON flw.person_id = persons.person_id
          WHERE persons.person_id IS NULL
      ) AS c
    )
  );

ALTER TABLE `Followers` ADD CONSTRAINT `Followers_uid_30d71699_uniq`
UNIQUE (`uid`, `person_id`);
ALTER TABLE `FriendGroupMember` ADD CONSTRAINT `FriendGroupMember_uid_30d71699_uniq`
UNIQUE (`uid`, `person_id`, `fgroup_id`);

ALTER TABLE Followers DROP PRIMARY KEY;
ALTER TABLE FriendGroupMember DROP PRIMARY KEY;

ALTER TABLE Followers ADD id INTEGER AUTO_INCREMENT PRIMARY KEY NOT NULL;
ALTER TABLE FriendGroupMember ADD id INTEGER AUTO_INCREMENT PRIMARY KEY NOT NULL;

ALTER TABLE Followers ADD FOREIGN KEY (uid) REFERENCES persons(person_id);
ALTER TABLE Followers ADD FOREIGN KEY (person_id) REFERENCES persons(person_id);

ALTER TABLE FriendGroupMember ADD FOREIGN KEY (uid) REFERENCES persons(person_id);
ALTER TABLE FriendGroupMember ADD FOREIGN KEY (person_id) REFERENCES persons(person_id);

-- ALTER TABLE persons ADD has_access BOOL NOT NULL DEFAULT FALSE;
ALTER TABLE persons MODIFY has_access BOOL;

-- generate_bulca_item_no
-- GRANT SELECT ON mysql.proc TO at;
-- GRANT CREATE ROUTINE TO at;
DELIMITER ;;
CREATE PROCEDURE `generate_bulca_item_no`(IN feed_id BIGINT)
    MODIFIES SQL DATA
    SQL SECURITY INVOKER
BEGIN
                INSERT INTO ItemsBulcaIncrementer(feed_id, last_item_no) VALUES (feed_id, LAST_INSERT_ID(1)) ON DUPLICATE KEY UPDATE last_item_no = LAST_INSERT_ID(last_item_no + 1);
                SELECT LAST_INSERT_ID();
        END;;
DELIMITER ;
