# coding: utf-8



import os

from celery import Celery, Task, signals
from django import db
from django_tools_log_context.celery import CtxAwareMixin


# set the default Django settings module for the 'celery' program.
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'at.settings')

from django.conf import settings  # noqa


class AtCeleryTask(CtxAwareMixin, Task):
    _execution_threshold = 0


app = Celery('at', task_cls=AtCeleryTask)

app.config_from_object('django.conf:settings')
# не уверен, что эта штука хоть что-то полезное делает
app.autodiscover_tasks(lambda: settings.INSTALLED_APPS)

# Подчищаем протухшие соединения с базой перед каждой таской
signals.task_prerun.connect(db.close_old_connections)
