# coding: utf-8

from collections import defaultdict


class Checker(object):
    """ Stores club data loaded through self.load() and applies the filters. """
    def __init__(self, reqs=None):
        self.__data = defaultdict(lambda: defaultdict(int))
        self.__requirements = reqs

    def load(self, data):
        # accepts {id: {field_names: field_values}, id2: {field_names: field_values}, ...}
        for feed_id, fields in data.items():
            for k, v in fields.items(): # can't simply copy dict, b/c need a defaultdict
                self.__data[feed_id][k] = v

    def check(self, feed_id, fields=None):
        fields = fields or list(self.__requirements.keys())
        club_data = self.__data[feed_id]
        return all(club_data[f] >= self.__requirements[f] for f in fields)

    def check_one(self, feed_id, field):
        return self.check(feed_id, [field])

    def filter(self, field=None, blacklist=[]):
        """ Removes all entries in the container that don't match the requirements.
            If a field is specified, filters by that condition only. Otherwise, by all four.
            If a blacklist is present, removes those too.
        """
        for feed_id in list(self.__data.keys()):
            if feed_id in blacklist \
                    or not self.check(feed_id, ([field] if field else None)):
                del self.__data[feed_id]

    def get_ids(self):
        return list(self.__data.keys())

    def __getitem__(self, key):
        return self.__data[key]

