# -*- coding: utf-8 -*-
class CurlException(Exception):
    pass

class TimedOutException(CurlException):
    pass

class CouldntConnectException(CurlException):
    pass

_curl_error_to_exception = {
    28: TimedOutException,
    7: CouldntConnectException,
    }

def curl_exc(curl_exc_args):
    (ret_code, message) = curl_exc_args
    return _curl_error_to_exception.get(ret_code, CurlException)(message)
