# -*- coding: utf-8 -*-

from .utils import get_connection

from hashlib import sha1 as sha
import random

from at.common import dbswitch


def _not_impl():
    raise RuntimeError("not implemented yet")
    return None


def _regenerate_private_key_impl(person_id, connection):
    _random_generator = lambda x: "".join([hex(sym)[2:] for sym in [random.randint(0, 200) for s in range(x)]])
    new_private_key = _random_generator(20)
    connection.execute('REPLACE INTO MailKeys(person_id, mail_key) VALUES(%d, %%s)' % person_id, new_private_key)


def regenerate_private_key(person_id):
    with get_connection() as connection:
        _regenerate_private_key_impl(person_id, connection)


def _get_or_create_private_key(person_id):
    with get_connection() as connection:
        rows = None
        counter = 0
        while not rows and counter < 10:
            cursor = connection.execute('SELECT mail_key FROM MailKeys WHERE person_id = %d' % person_id)
            rows = [row[0] for row in cursor]
            if not rows:
                _regenerate_private_key_impl(person_id, connection)
                counter += 1
        if counter == 10:
            raise RuntimeError("can't generate private key")
        return rows[0]


def sign_message(person_id, message):
    key = _get_or_create_private_key(person_id)
    if isinstance(key, str):
        key = key.encode('utf-8')
    if isinstance(message, str):
        message = message.encode('utf-8')

    return sha(key + message).hexdigest()


class KeyRing:
    def __init__(self):
        pass
