# -*- coding: utf-8 -*-

import logging

from at.common.utils import log_exception
from at.common.utils import get_connection

_log = logging.getLogger(__name__)


class Lock(object):
    def __init__(self, name):
        self.__name = name
        self.__connection = None

    @log_exception
    def acquire(self, timeout):
        self.__connection = get_connection()
        cursor = self.__connection.execute("select get_lock(%s, %s)", (self.__name, timeout))
        res, = cursor.fetchone()
        return res

    @log_exception
    def release(self):
        if self.__connection is None:
            _log.error("Can't release lock: lock is not acquired")
            return

        try:
            cursor = self.__connection.execute("select release_lock(%s)", (self.__name,))
        finally:
            self.__connection.close()

    def __enter__(self):
        if self.acquire(3) != 1:
            raise RuntimeError("Can't acquire lock %s" % self.__name)
        return self

    def __exit__(self, type, value, traceback):
        self.release()
