# -*- coding: utf-8 -*-

import time

from at.common import Mapper


class LongJobMapper(Mapper.StrictMapper):

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.table_name = "LongJobs"
        self.data_fields = ['start_time']
        self.data_template = '%d'

        self.key_fields = ['job_name']
        self.key_template = "'%s'"
        self.insert_with = "REPLACE INTO"


class LongJobException(Exception):
    pass


class LongJob(object):
    def __init__(self, person_id, job_name):
        self._person_id = person_id
        self._job_name = job_name

    def __str__(self):
        return "LongJob(person_id = %d, job_name = %s)" % (self._person_id, self._job_name)
    def __repr__(self):
        return str(self)

    def get_name(self):
        return self._job_name

    def _is_expired(self, start_time):
        return time.time() - start_time > 60 * 30

    def _mapper(self):
        return LongJobMapper(self._person_id)

    def is_active(self):
        start_time = self._mapper()[(self._job_name, )]
        if (not start_time) or self._is_expired(start_time[0]):
            return False
        return True

    def start(self):
        if self.is_active():
            raise LongJobException("job %s is already started!" % self)
        self._mapper()[(self._job_name, )] = (int(time.time()), )

    def stop(self):
        self._mapper().delete((self._job_name, ))

