# coding: utf-8


from at.aux_.MongoStorage import Storage


def dict_diff(example, target):
    res = {}
    for key, value in list(example.items()):
        target_value = target.get(key)
        if  target_value is not None and target_value != value:
            res[key] = target_value
    return res


class StorageAttach(type):

    def __new__(cls, name, bases, attrs):
        collection_name = "%s_storage" % name
        storage = Storage(collection_name)
        attrs['storage'] = storage
        return type.__new__(cls, name, bases, attrs)


class MongoFeedDict(object, metaclass=StorageAttach):

    def __init__(self, feed_id):
        self.feed_id = feed_id
        self._data = None

    def _create_default_values(self):
        data = {"feed_id": self.feed_id,
             "dict_data": dict(self.default_values)}
        self.storage.insert(
            data
        )
        return data

    def __getattr__(self, key):
        if key in self.default_settings:
            return self.data[key]
        raise AttributeError("'%s' object has no attribute '%s'" % (self.__class__.__name__,
                                                                    key))
    def __setattr__(self, key, value):
        if key in self.default_settings:
            self.data[key] = value
        else:
            object.__setattr__(self, key, value)

    def save(self):
        if self._data:
            data = dict_diff(self.default_settings, self._data)
            self.storage.update(
                {"feed_id": self.feed_id},
                {"$set": {"dict_data": data}},
                upsert=True,
            )

    @property
    def data(self):
        if self._data is None:
            mongo_object = self.storage.find_one({"feed_id": self.feed_id})
            dict_data = dict(self.default_settings)
            if mongo_object is not None:
                dict_data.update(mongo_object["dict_data"])
            self._data = dict_data
        return self._data
