# -*- coding: utf-8 -*-

import logging

import lxml.etree as ET

from at.common.MagicTable import MagicTable
from at.common.utils import get_connection

logger = logging.getLogger(__name__)


class Rubric(object):
    def __init__(self, d):
        self.c_count = 0
        for k, v in d.items():
            setattr(self, k, v)

    def to_elem(self, lang='ru'):
        attribs = {
                   "rubric_id": str(self.rubric_id),
                   "count": str(self.c_count),
                   "name": getattr(self, 'name_' + lang)
                   }
        return ET.Element("rubric", attribs)


Rubrics = MagicTable('CommunitiesRubrics',
        'rubric_id, name_ru, name_en, hidden, metarubric', Rubric, quiet=False)


def set_rubric(feed_id, item_no, rubric_id):
    logger.debug('Set rubric %s for %s %s', rubric_id, feed_id, item_no)
    sql = 'UPDATE Posts set rubric_id = %s where person_id = %s and post_no = %s'
    with get_connection() as conn:
        conn.execute(sql, (rubric_id, feed_id, item_no))


class NoRubric(Exception): pass


def get_rubric(feed_id, item_no):
    try:
        with get_connection() as conn:
            rubric_id ,= conn.execute('''
                    SELECT rubric_id FROM Posts
                    WHERE person_id = %s and post_no = %s
            ''', (feed_id, item_no)).fetchone()
            return Rubrics().by_rubric_id(rubric_id)
    except (TypeError, IndexError):
        raise NoRubric(feed_id, item_no)


def get_all_hidden_rubrics():
    return [row[0]['rubric_id'] for row in Rubrics().rows
                if row[0]['metarubric'] == 'hidden']


