# *-* coding: utf-8 *-*

import yenv
import logging

from at.aux_.models import Person
from at.common import staff

logger = logging.getLogger(__name__)


FORCED_DEPARTMENTS = set(('as_office',))

# в тестинге — всем внутренним роботам, в проде — только этушковым
if yenv.type == 'production':
    FORCED_DEPARTMENTS.add('virtual_internal_at')
else:
    FORCED_DEPARTMENTS.add('virtual_internal')


FORCED_GROUPS = set(('atushkadostup', ))

if yenv.type == 'testing':
    # AT-2653 в тестинге выдаем доступ поддержке
    FORCED_GROUPS.add('svc_support')

AFFILIATIONS = ('yandex',
                'yamoney')


ACCESS_CHECK_STAFF_FIELDS = (
    'login',
    'department_group.url',
    'department_group.ancestors.url',
    'official.affiliation',
    'official.is_dismissed',
    'groups.group.url',
)


def get_person_from_staff(uid):
    api = staff.Api()
    try:
        return api.persons.fields(','.join(ACCESS_CHECK_STAFF_FIELDS)).filter(uid=uid)[0]
    except IndexError:
        return


def check_accessibility(uid):
    if yenv.type == 'development':
        return True

    result = False
    try:
        person = Person.objects.filter(person_id=uid).first()
        if person:
            # TODO: check
            # fucking mysql bit field, never use it again
            # result = query_res[0] == '\x01'
            result = bool(person.has_access)
    except Exception:
        logger.exception("Exception while check person {} access rights".format(uid))

    return result
