# coding: utf-8

from threading import Lock


class Singleton(object):
    __all_singletons_lock = Lock()
    __instance = None

    def __new__(classtype, *args, **kwargs):
        def _is_created():
            return classtype == type(classtype.__instance)
        if not _is_created():
            with Singleton.__all_singletons_lock:
                if not _is_created():
                    classtype.__instance = object.__new__(classtype, *args, **kwargs)
                    return classtype.__instance
        return None

    @classmethod
    def getInstance(classtype):
        ret = classtype.__new__(classtype)
        if ret:
            classtype.__init__(ret)
        else:
            ret = classtype.__instance
        return ret
