# -*- coding: utf-8 -*-

import lxml.etree as ET


def assertion(value, field, condition, comment=''):
    if value:
        return

    raise AssertionFailure(assertions=[
        FailedAssertion(field, CONDITIONS[condition], comment)
    ])


class ConditionType(str):
    pass


CONDITIONS = {
    'NOT_EMPTY': ConditionType('NOT_EMPTY'),
    'NOT_NULL': ConditionType('NOT_NULL'),
    'NOT_VALID': ConditionType('NOT_VALID'),
    'ACCESS_DENIED': ConditionType('ACCESS_DENIED'),
}


class FailedAssertion(object):
    def __init__(self, name, condition, comment=''):
        self.name = name
        self.condition = condition
        self.comment = comment


class AssertionFailure(Exception):

    def __init__(self, assertions):
        self.assertions = assertions


# этот код формирует xml, который (по крайней мере иногда)
# правильно обрабатывается фронтендом и выводит правильные ошибки,
# так что пришлось это отавить
def assert2str(value, root=None, _name=None, recurse=5):
    name = _name if _name is not None else value.__class__.__name__
    root_ = root if root is not None else ET.Element(name)
    if isinstance(value, (str, ConditionType)):
        root_.attrib[name] = value.encode('utf-8')
        return None
    if isinstance(value, list) and recurse:
        container = ET.SubElement(root_, name)
        for x in value:
            assert2str(value=x, root=container, _name=None, recurse=recurse-1)
        return None
    this_node = ET.SubElement(root_, value.__class__.__name__)
    if _name is not None:
        this_node.attrib["attr_name"] = name
    if recurse:
        attributes = set([x for x in dir(value) if x and (x[0] != '_' and x != "func_code")])
        [assert2str(getattr(value, attr), this_node, attr, recurse=recurse-1) for attr in attributes]
    if root is None:
        return ET.tostring(this_node)

