# coding: utf-8




class COMMENT_MODES(object):
    NONE = 'n'
    ALL = 'a'
    FRIENDS = 'f'

    VERBOSE = {
        NONE: 'none',
        ALL: 'all',
        FRIENDS: 'friends',
    }
    CHOICES = list(VERBOSE.items())


class DIGEST_MODES(object):
    DISABLED = 'd'
    POPULAR = 'p'
    FULL = 'f'
    ALL = 'a'

    VERBOSE = {
        DISABLED: 'disabled',
        POPULAR: 'popular',
        FULL: 'full',
        ALL: 'all'
    }

    CHOICES = list(VERBOSE.items())


class NOTIFICATION_FIELDS(object):
    COMMENT_MODE = 'comment_mode'
    DIGEST_MODE = 'digest_mode'
    NOTIFY_SUMMONS = 'notify_summons'
    NOTIFY_INVITES = 'notify_invites'
    NOTIFY_SELF = 'notify_self'
    NOTIFY_MODERATION = 'notify_moderation'

    DEFAULTS = {
        COMMENT_MODE: COMMENT_MODES.ALL,
        DIGEST_MODE: DIGEST_MODES.DISABLED,
        NOTIFY_SUMMONS: True,
        NOTIFY_INVITES: True,
        NOTIFY_SELF: False,
        NOTIFY_MODERATION: True,
    }


class LEGACY(object):
    F = NOTIFICATION_FIELDS
    NOTIFICATIONS_FIELDS_OLD_NEW = {
        'comments_notification_mode': F.COMMENT_MODE,
        'digest_mode': F.DIGEST_MODE,
        'summons': F.NOTIFY_SUMMONS,
        'invites': F.NOTIFY_INVITES,
        'self_mailing': F.NOTIFY_SELF,
        'moderation': F.NOTIFY_MODERATION,
    }
    NOTIFICATIONS_FIELDS_NEW_OLD = {
        v: k for k, v in list(NOTIFICATIONS_FIELDS_OLD_NEW.items())
    }

    COMMENT_MODE_OLD_NEW = {
        0: COMMENT_MODES.NONE,
        1: COMMENT_MODES.ALL,
        2: COMMENT_MODES.FRIENDS,
    }
    COMMENT_NOTIFICATION_MODE_NEW_OLD = {
        v: k for k, v in list(COMMENT_MODE_OLD_NEW.items())
    }

    DIGEST_MODE_OLD_NEW = {
        0: DIGEST_MODES.DISABLED,
        1: DIGEST_MODES.POPULAR,
        2: DIGEST_MODES.FULL,
        3: DIGEST_MODES.ALL,
    }
    DIGEST_MODE_NEW_OLD = {
        v: k for k, v in list(DIGEST_MODE_OLD_NEW.items())
    }
