# coding: utf-8

from .MongoFeedDict import StorageAttach


class FeedWeightCounter(object, metaclass=StorageAttach):
    def __init__(self, person_id):
        self.person_id = person_id

    def increment(self, feed_id, value=1):
        self.storage.update(
            {'person_id': self.person_id,
             'feed_id': feed_id},
            {'$inc': {'score': value}},
            upsert=True
        )

    def decrement(self, feed_id, value=1):
        return self.increment(feed_id, value * -1)

    def get_scores(self, feed_ids):
        return self.__as_dict(self.storage.find(
            {'feed_id': {'$in': feed_ids}}))

    def get_top_n(self, n=10):
        return self.__as_dict(self.storage.find({'person_id': self.person_id})
                              .sort('score', -1)
                              .limit(n))

    def __as_dict(self, cursor):
        return dict(
            (el['feed_id'], el['score']) for el in cursor
        )
