# -*- coding: utf-8 -*-

class GroupType:
    # доступно для всех — этот уровень доступа может быть у поста,
    # в fgm для чтения этих постов запись не нужна
    USER = 0

    # уровни доступа для персональных дневников (значения отсортированы)
    FRIEND = 10
    OWNER = 20

    # уровни доступа для клубов (значения отсортированы)
    MEMBER = 50
    MODERATOR = 60

    # константы из шкалы персональных дневников несравнимы с константами
    # из шкалы клубов, для них есть только общий уровень — USER = 0

    # специальные доступы — порядок чисел для них не имеет значения
    INVITED = 100
    MODERATOR_INVITED = 110
    BANNED = 120

    _num2str = {
        OWNER: "OWNER",
        USER: "USER",
        BANNED: "BANNED",
        MODERATOR: "MODERATOR",
        MEMBER: "MEMBER",
        FRIEND: "FRIEND",
        INVITED: "INVITED",
        MODERATOR_INVITED: "MODERATOR_INVITED",
    }

    invite = {
        MEMBER: INVITED,
        MODERATOR: MODERATOR_INVITED,
    }

    @staticmethod
    def get_num(string):
        return getattr(GroupType, string.upper())

    @staticmethod
    def get_str(value):
        return GroupType._num2str.get(value, 'unknown-%d' % value)
     
    expansions = {
        MODERATOR_INVITED:
            set([INVITED]),
        MEMBER:
            set([INVITED]),
        MODERATOR:
            set([INVITED, MEMBER, OWNER]),
        OWNER:
            set([INVITED, MEMBER, MODERATOR]),
    }
    @staticmethod
    def expand_role(role):
        result = set([role, GroupType.USER])
        # Анонима, возможно, надо удалить
        result.update(GroupType.expansions.get(role, []))
        return result

    @staticmethod
    def upscale_role(role):
        return GroupType.upscale_roles([role])

    @staticmethod
    def upscale_roles(roles):
        # список тех ролей, которые превосходят заданную (для счётчиков и выборок)
        result = set(roles)
        for k, v in GroupType.expansions.items():
            if v.intersection(roles):
                result.add(k)
        return result
        
    @staticmethod
    def expand_roles(roles):
        result = set()
        for role in roles:
            if role == GroupType.BANNED:
                return GroupType.expand_role(role)
            else:
                result.update(GroupType.expand_role(role))
        return result

class Type:
    POST = 0
    READ = 1
    COMMENT = 2
    ADD_TO_FGROUP = 3
    BAN_A_USER = 4
    UPDATE_ANY_ITEM = 5
    UPDATE_OWN_POST = 6
    BECOME_A_FGROUP_MEMBER = 7
    DELETE_FROM_FGROUP = 8
    LEAVE_A_FGROUP = 9
    BAN_ANY_EXCEPT = 10
    UPDATE_OWN_COMMENT = 11
    CREATE_CUSTOM_FRIEND_GROUP = 12
    UPDATE_PROFILE = 13
    UPGRADE_YOURSELF = 14
    POST_PREMODERATED = 15
    GET_FRIENDLIST = 16
    READ_FEED = 17
    READ_CONTACTS = 18
    READ_ANKETA = 19

    _num2str = {
        0: "POST",
        1: "READ",
        2: "COMMENT",
        3: "ADD_TO_FGROUP",
        4: "BAN_A_USER",
        5: "UPDATE_ANY_ITEM",
        6: "UPDATE_OWN_POST",
        7: "BECOME_A_FGROUP_MEMBER",
        8: "DELETE_FROM_FGROUP",
        9: "LEAVE_A_FGROUP",
        10: "BAN_ANY_EXCEPT",
        11: "UPDATE_OWN_COMMENT",
        12: "CREATE_CUSTOM_FRIEND_GROUP",
        13: "UPDATE_PROFILE",
        14: "UPGRADE_YOURSELF",
        15: "POST_PREMODERATED",
        16: "GET_FRIENDLIST",
        17: "READ_FEED",
        18: "READ_CONTACTS",
        19: "READ_ANKETA",
        }

    @staticmethod
    def get_str(value):
        return Type._num2str[value]




# строки приходят из форм на клиенте
# id из GroupType
class AccessLevel(object):
    PUBLIC = 'public'
    PRIVATE = 'private'
    ALL_FRIENDS = 'all_friends'
    MODERATORS = 'moderators'
    MEMBERS = 'members'

str_access_type_to_fgroup_id = {
    AccessLevel.PUBLIC: GroupType.USER,
    AccessLevel.PRIVATE: GroupType.OWNER,
    AccessLevel.ALL_FRIENDS: GroupType.FRIEND,
    AccessLevel.MODERATORS: GroupType.MODERATOR,
    AccessLevel.MEMBERS: GroupType.MEMBER,
}

fgroup_id_to_str_access_type = dict(
    (val, key) for key, val in list(str_access_type_to_fgroup_id.items())
)

# это кажется не нужно, но откуда-то, кажется прилетает иногда
str_access_type_to_fgroup_id['friends'] = GroupType.FRIEND


def get_int_access(s):
    return str_access_type_to_fgroup_id.get(s, GroupType.USER)


def get_str_access(int_access):
    return fgroup_id_to_str_access_type[int_access]

