# coding: utf-8

from django.conf import settings
from at.common.utils import get_connection
from at.aux_ import ProfileStorage
from at.pump import HandlerRegistry


def get_settings(ai):
    """Load a profile category for specific user and parse it.

    Return (selected, settings) tuple, where selected is a list of staff groups selected by the user,
    and settings is a dictionary of other settings.
    """

    data = ProfileStorage.get_category(ai, ai.uid, 'IntraFriending')
    selected = set(int(value) for value, _ in data['staff-group'])
    settings = dict([(k, v[0][0]) for k,v in data.items()
                                    if k != 'staff-group'])
    return selected, settings


def get_friend_list(person_id):
    """Load user friends.

    Returns (all, auto) tuple, where 'all' is a set of uids of all friends, and
    'auto' is a set of friends added automatically.
    """

    with get_connection() as conn:
        res = conn.execute('SELECT uid, in_work FROM FriendGroupMember where person_id = %s and fgroup_id = 0', (person_id,))

    all_friends = set()
    auto_friends = set()

    for uid, in_work in res:
        all_friends.add(uid)
        if in_work:
            auto_friends.add(uid)

    return all_friends, auto_friends

def get_qu_persons(limit):
    """Return a set of uids of users with qu greater or equal to the limit."""
    sql = "select person_id from persons where person_id < %s and status = 'normal' and qu >= %s"
    with get_connection() as conn:
        return set(uid for uid, in conn.execute(sql % (settings.COMMUNITY_START_ID, limit)))


def update_person(ai):
    """Update automatic friendships.

    Will load friend list and selected groups' members and spawn pumper events as needed.
    """
    pass
    selected, settings = get_settings(ai)
    friends, autofriends = get_friend_list(ai.uid)

    # TODO: заменить центр на staff-api
    # wanted = center.api.get_groups_members(selected) - set([ai.uid])
    #
    # if settings.get('qu-enable'):
    #     enough_qu = get_qu_persons(settings['qu-limit'])
    #     wanted.update(enough_qu)
    #
    # for feed_id in wanted - friends:
    #     HandlerRegistry.put_event('AutofriendingHandler', feed_id, ai.uid)
    #
    # if settings.get('auto-unfriend') != 'off':
    #     for feed_id in autofriends - wanted:
    #         HandlerRegistry.put_event('UnfriendHandler', feed_id, ai.uid)
