# coding: utf-8



import logging

from ids.registry import registry
from ids import exceptions

from at.common import oauth
from at.common.tvm2_client import get_service_ticket

log = logging.getLogger(__name__)


def get_repo(auth=None):
    params = dict(
        service='intrasearch',
        resource_type='suggest',
        user_agent='at',
        retries=3,
    )
    if auth:
        params['service_ticket'] = get_service_ticket('search')
        params['user_ticket'] = auth.user_ticket
    else:
        params['oauth_token'] = oauth.get_token_for_robot()

    return registry.get_repository(**params)


def get_layer_suggest(text, auth=None, layer='people', per_page=10, query=None):
    query = query or {}
    repo = get_repo(auth)
    lookup = {
        'text': text,
        'layers': layer,
        layer + '.per_page': per_page,
    }
    lookup.update(query)
    try:
        results = repo.get(lookup)
    except exceptions.IDSException:
        log.exception('Isearch suggest request failed')
        return []

    # we making one layer requests
    return results[0]['result']


def get_maillist_suggest(text, auth=None, per_page=10):
    return get_layer_suggest(
        auth=auth, text=text, layer='ml', per_page=per_page)


def get_email_by_id(email_exact):
    query = {
        'ml.query': 's_email:"%s"' % email_exact
    }
    results = get_layer_suggest(text=email_exact, layer='ml', query=query)
    if results:
        return results[0]


def get_queues_suggest(text, auth=None, per_page=10):
    return get_layer_suggest(
        auth=auth, text=text, layer='queues', per_page=per_page)
