# *-* encoding: utf-8 *-*

import logging

from at.common.utils import get_connection

_log = logging.getLogger('aux')


def per_item_loader(ids, query, fields):
    """
        Это такая хрень, которая умеет загружать данные, ассоциированные
        с конкретным постом.
        ids – список идентификаторов вида \d+(\.\d+)* (id/asString поста или коммента).
        fields – список имён полей, соответствующих этим \d+
    """
    item_tuples = [tuple(map(int, _id.split('.'))) for _id in ids]

    condition_template = " AND ".join("%s=%%d" % field for field in fields)
    condition_template = "(%s)" % condition_template
    conditions = " OR ".join(condition_template % t for t in item_tuples)

    with get_connection() as conn:
        rows = list(conn.execute(query % conditions))

    id_template = '.'.join('%d' for _ in fields)
    rows = [tuple(row) for row in rows]
    if not rows:
        return {}
    extra_fields = len(rows[0]) - len(fields)
    d = (lambda r: r[-1]) if extra_fields == 1 else (lambda r: tuple(r[-extra_fields:]))
    return dict((id_template % row[:len(fields)], d(row)) for row in rows)


