# coding: utf-8



from ylog import context


class ContextLoggingMiddleware(object):

    def process_request(self, request):
        for key, value in list({
            'login': request.ai and request.ai.login,
            'req_id': id(request),
        }.items()):
            context.put_to_context(key, value)

    def process_response(self, request, response):
        for key in ('login', 'req_id'):
            context.pop_from_context(key)
        return response
