# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2018-02-28 15:47


from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Bday',
            fields=[
                ('person_id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('bday', models.CharField(blank=True, max_length=5, null=True)),
            ],
            options={
                'db_table': 'bday',
            },
        ),
        migrations.CreateModel(
            name='Comments',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_id', models.BigIntegerField()),
                ('author_uid', models.BigIntegerField()),
                ('post_no', models.BigIntegerField()),
                ('comment_id', models.IntegerField()),
                ('parent_id', models.IntegerField()),
                ('level', models.IntegerField()),
                ('children_count', models.IntegerField()),
                ('store_time', models.DateTimeField()),
                ('item_time', models.DateTimeField()),
                ('screened', models.IntegerField()),
                ('deleted', models.IntegerField()),
                ('freezed', models.IntegerField()),
                ('comment_type', models.IntegerField()),
            ],
            options={
                'db_table': 'Comments',
            },
        ),
        migrations.CreateModel(
            name='Commentsfullparents',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_id', models.BigIntegerField()),
                ('post_no', models.IntegerField()),
                ('parent_id', models.IntegerField()),
                ('comment_id', models.IntegerField()),
                ('level_diff', models.IntegerField()),
            ],
            options={
                'db_table': 'CommentsFullParents',
            },
        ),
        migrations.CreateModel(
            name='Communities',
            fields=[
                ('feed_id', models.BigIntegerField(unique=True)),
                ('rated', models.CharField(max_length=9)),
                ('adult', models.CharField(max_length=9)),
                ('rating', models.IntegerField()),
                ('name', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('rubric_id', models.IntegerField(blank=True, null=True)),
                ('min_qu_for_posting', models.IntegerField()),
                ('no_user_tags', models.IntegerField()),
            ],
            options={
                'db_table': 'Communities',
            },
        ),
        migrations.CreateModel(
            name='Communitiesrubrics',
            fields=[
                ('rubric_id', models.AutoField(primary_key=True, serialize=False)),
                ('name_ru', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('hidden', models.IntegerField()),
                ('metarubric', models.CharField(blank=True, max_length=6, null=True)),
            ],
            options={
                'db_table': 'CommunitiesRubrics',
            },
        ),
        migrations.CreateModel(
            name='Communitiessequence',
            fields=[
                ('feed_id', models.BigAutoField(primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'CommunitiesSequence',
            },
        ),
        migrations.CreateModel(
            name='Communitiesstat',
            fields=[
                ('feed_id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('members_count', models.IntegerField(blank=True, null=True)),
                ('posts_count', models.IntegerField(blank=True, null=True)),
                ('last_comment_time', models.DateTimeField()),
                ('last_post_time', models.DateTimeField()),
                ('last_month_posts', models.IntegerField(blank=True, null=True)),
                ('last_month_comments', models.IntegerField(blank=True, null=True)),
                ('commentator_count', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'CommunitiesStat',
            },
        ),
        migrations.CreateModel(
            name='Entryxmlcontent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feed_id', models.BigIntegerField()),
                ('post_no', models.BigIntegerField()),
                ('comment_id', models.IntegerField()),
                ('xml', models.TextField(blank=True, null=True)),
                ('wf_version', models.CharField(blank=True, max_length=10, null=True)),
            ],
            options={
                'db_table': 'EntryXmlContent',
            },
        ),
        migrations.CreateModel(
            name='Fgmcountersupdatequery',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('person_id', models.BigIntegerField(unique=True)),
                ('total', models.IntegerField()),
            ],
            options={
                'db_table': 'FGMCountersUpdateQuery',
            },
        ),
        migrations.CreateModel(
            name='Friendgroupmembercounter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_id', models.BigIntegerField()),
                ('fgroup_id', models.IntegerField()),
                ('mutually', models.IntegerField()),
                ('hide_unwanted', models.IntegerField()),
                ('direction', models.CharField(max_length=8)),
                ('count', models.IntegerField()),
            ],
            options={
                'db_table': 'FriendGroupMemberCounter',
            },
        ),
        migrations.CreateModel(
            name='Itemsbulcaincrementer',
            fields=[
                ('feed_id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('last_item_no', models.BigIntegerField()),
            ],
            options={
                'db_table': 'ItemsBulcaIncrementer',
            },
        ),
        migrations.CreateModel(
            name='Itemsbulcainfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feed_id', models.BigIntegerField()),
                ('item_no', models.BigIntegerField()),
                ('bulca_unit_id', models.IntegerField()),
                ('bulca_item_no', models.BigIntegerField()),
            ],
            options={
                'db_table': 'ItemsBulcaInfo',
            },
        ),
        migrations.CreateModel(
            name='Itemtypes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('service', models.CharField(max_length=255)),
                ('group_id', models.IntegerField(blank=True, null=True)),
                ('exportable', models.CharField(max_length=9)),
            ],
            options={
                'db_table': 'ItemTypes',
            },
        ),
        migrations.CreateModel(
            name='Likes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feed_id', models.BigIntegerField()),
                ('item_no', models.BigIntegerField()),
                ('comment_id', models.BigIntegerField()),
                ('uid', models.BigIntegerField()),
                ('title', models.CharField(max_length=255)),
                ('url', models.CharField(max_length=255)),
                ('timestamp', models.DateTimeField()),
                ('value', models.IntegerField()),
            ],
            options={
                'db_table': 'Likes',
            },
        ),
        migrations.CreateModel(
            name='Longjobs',
            fields=[
                ('person_id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('job_name', models.CharField(max_length=255)),
                ('start_time', models.BigIntegerField()),
            ],
            options={
                'db_table': 'LongJobs',
            },
        ),
        migrations.CreateModel(
            name='Mailkeys',
            fields=[
                ('person_id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('mail_key', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'db_table': 'MailKeys',
            },
        ),
        migrations.CreateModel(
            name='Mailsettings',
            fields=[
                ('person_id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('mailing_style', models.IntegerField()),
                ('self_mailing', models.IntegerField()),
                ('use_alt_mail', models.IntegerField()),
                ('alt_mail', models.CharField(max_length=255)),
                ('encoding', models.CharField(max_length=100)),
                ('wanthtml', models.IntegerField(db_column='wantHtml')),
                ('rg_filter', models.IntegerField()),
                ('rg_timer', models.IntegerField()),
                ('rg_last_sent', models.DateTimeField()),
                ('send_relation_mail', models.IntegerField()),
                ('send_digest', models.IntegerField()),
                ('digest_mode', models.IntegerField()),
            ],
            options={
                'db_table': 'MailSettings',
            },
        ),
        migrations.CreateModel(
            name='Postaccesses',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feed_id', models.BigIntegerField()),
                ('post_no', models.IntegerField()),
                ('fgroup_id', models.SmallIntegerField()),
                ('deleted', models.IntegerField()),
            ],
            options={
                'db_table': 'PostAccesses',
            },
        ),
        migrations.CreateModel(
            name='Postcategories',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feed_id', models.BigIntegerField()),
                ('post_no', models.BigIntegerField()),
                ('cat_id', models.BigIntegerField()),
                ('deleted', models.IntegerField()),
            ],
            options={
                'db_table': 'PostCategories',
            },
        ),
        migrations.CreateModel(
            name='Postcategory',
            fields=[
                ('person_id', models.BigIntegerField()),
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('title_tag', models.CharField(max_length=100)),
            ],
            options={
                'db_table': 'PostCategory',
            },
        ),
        migrations.CreateModel(
            name='Posts',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_id', models.BigIntegerField()),
                ('author_uid', models.BigIntegerField(blank=True, null=True)),
                ('post_no', models.BigIntegerField()),
                ('store_time', models.DateTimeField()),
                ('store_time_month_year', models.DateField()),
                ('item_time', models.DateTimeField()),
                ('post_type', models.IntegerField()),
                ('deleted', models.IntegerField(default=0)),
                ('public', models.IntegerField(default=1)),
                ('store_time_usec', models.BigIntegerField()),
                ('access_type', models.IntegerField(default=1)),
                ('is_imported', models.IntegerField(default=1)),
                ('deleted_manually', models.IntegerField(default=0)),
                ('last_updated', models.DateTimeField()),
                ('children_count', models.SmallIntegerField()),
                ('last_comment_id', models.IntegerField(blank=True, null=True)),
                ('screened', models.IntegerField(default=0)),
                ('freezed', models.IntegerField(default=0)),
                ('last_author_uid', models.BigIntegerField(blank=True, null=True)),
                ('rubric_id', models.SmallIntegerField()),
                ('score', models.FloatField(default=0)),
                ('store_time_most_interesting_usec', models.BigIntegerField(blank=True, null=True)),
                ('store_time_interesting_usec', models.BigIntegerField(blank=True, null=True)),
                ('popular_category', models.SmallIntegerField()),
                ('access_group', models.IntegerField(blank=True, null=True)),
                ('on_moderation', models.IntegerField(default=0)),
                ('pinned_after', models.BigIntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'Posts',
            },
        ),
        migrations.CreateModel(
            name='Poststoredata',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feed_id', models.BigIntegerField()),
                ('item_no', models.BigIntegerField()),
                ('link_md5', models.CharField(max_length=16)),
            ],
            options={
                'db_table': 'PostStoreData',
            },
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feed_id', models.BigIntegerField()),
                ('category', models.CharField(max_length=30)),
                ('name', models.CharField(max_length=30)),
                ('value', models.CharField(max_length=20000)),
                ('content_type', models.CharField(max_length=4)),
            ],
            options={
                'db_table': 'Profile',
            },
        ),
        migrations.CreateModel(
            name='Readgroupmember',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.BigIntegerField()),
                ('rgroup_id', models.IntegerField()),
                ('type', models.CharField(max_length=2)),
                ('person_id', models.BigIntegerField()),
                ('cat_id', models.IntegerField()),
                ('in_work', models.IntegerField(blank=True, null=True)),
                ('hidden', models.IntegerField()),
            ],
            options={
                'db_table': 'ReadGroupMember',
            },
        ),
        migrations.CreateModel(
            name='Recentactionscounter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_id', models.BigIntegerField()),
                ('type', models.CharField(max_length=17)),
                ('count', models.IntegerField()),
                ('answered', models.SmallIntegerField()),
            ],
            options={
                'db_table': 'RecentActionsCounter',
            },
        ),
        migrations.CreateModel(
            name='Subscriptions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.BigIntegerField()),
                ('feed_id', models.BigIntegerField()),
                ('item_no', models.BigIntegerField()),
                ('with_comments', models.IntegerField()),
                ('mode', models.CharField(max_length=6)),
            ],
            options={
                'db_table': 'Subscriptions',
            },
        ),
        migrations.CreateModel(
            name='Timeguard',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('func', models.CharField(max_length=255)),
                ('time', models.DateTimeField()),
                ('host', models.CharField(blank=True, max_length=100, null=True)),
            ],
            options={
                'db_table': 'TimeGuard',
            },
        ),
        migrations.CreateModel(
            name='Trackbacks',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_id', models.BigIntegerField()),
                ('post_no', models.IntegerField()),
                ('comment_id', models.IntegerField()),
                ('trackback_person_id', models.BigIntegerField()),
                ('trackback_post_no', models.IntegerField()),
            ],
            options={
                'db_table': 'Trackbacks',
            },
        ),
        migrations.CreateModel(
            name='Unwantedpersons',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_id', models.BigIntegerField()),
                ('unwanted_feed_id', models.BigIntegerField()),
                ('add_date', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'db_table': 'UnwantedPersons',
            },
        ),
        migrations.CreateModel(
            name='Upscaleroles',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('original_fgroup_id', models.IntegerField()),
                ('upscaled_fgroup_id', models.IntegerField()),
            ],
            options={
                'db_table': 'UpscaleRoles',
            },
        ),
        migrations.CreateModel(
            name='Userscommentsstatistic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('count', models.BigIntegerField()),
                ('author_id', models.BigIntegerField()),
                ('type', models.IntegerField()),
            ],
            options={
                'db_table': 'UsersCommentsStatistic',
            },
        ),
        migrations.CreateModel(
            name='Userspostsstatistic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('count', models.BigIntegerField()),
                ('author_id', models.BigIntegerField()),
                ('type', models.IntegerField()),
            ],
            options={
                'db_table': 'UsersPostsStatistic',
            },
        ),
        migrations.CreateModel(
            name='Usersrelationsstatistic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('count', models.BigIntegerField()),
                ('author_id', models.BigIntegerField()),
                ('type', models.IntegerField()),
            ],
            options={
                'db_table': 'UsersRelationsStatistic',
            },
        ),
        migrations.CreateModel(
            name='Votes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('poll_id', models.CharField(max_length=55)),
                ('uid', models.BigIntegerField()),
                ('vote', models.SmallIntegerField()),
                ('timestamp', models.DateTimeField()),
            ],
            options={
                'db_table': 'Votes',
            },
        ),
        migrations.CreateModel(
            name='Widgetnames',
            fields=[
                ('widget_id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=50, unique=True)),
                ('enabled', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'WidgetNames',
            },
        ),
        migrations.CreateModel(
            name='Widgetsettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_id', models.BigIntegerField()),
                ('widget_id', models.IntegerField()),
                ('enabled', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'WidgetSettings',
            },
        ),
        migrations.AlterUniqueTogether(
            name='widgetsettings',
            unique_together=set([('person_id', 'widget_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='usersrelationsstatistic',
            unique_together=set([('author_id', 'type')]),
        ),
        migrations.AlterUniqueTogether(
            name='userspostsstatistic',
            unique_together=set([('author_id', 'type')]),
        ),
        migrations.AlterUniqueTogether(
            name='userscommentsstatistic',
            unique_together=set([('author_id', 'type')]),
        ),
        migrations.AlterUniqueTogether(
            name='upscaleroles',
            unique_together=set([('original_fgroup_id', 'upscaled_fgroup_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='unwantedpersons',
            unique_together=set([('person_id', 'unwanted_feed_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='trackbacks',
            unique_together=set([('person_id', 'post_no', 'comment_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='timeguard',
            unique_together=set([('func', 'time')]),
        ),
        migrations.AlterUniqueTogether(
            name='subscriptions',
            unique_together=set([('uid', 'feed_id', 'item_no')]),
        ),
        migrations.AlterUniqueTogether(
            name='recentactionscounter',
            unique_together=set([('person_id', 'type', 'answered')]),
        ),
        migrations.AlterUniqueTogether(
            name='readgroupmember',
            unique_together=set([('uid', 'rgroup_id', 'type', 'person_id', 'cat_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='poststoredata',
            unique_together=set([('feed_id', 'link_md5')]),
        ),
        migrations.AlterUniqueTogether(
            name='posts',
            unique_together=set([('post_no', 'person_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='postcategory',
            unique_together=set([('person_id', 'title_tag'), ('id', 'person_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='postcategories',
            unique_together=set([('feed_id', 'post_no', 'cat_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='likes',
            unique_together=set([('feed_id', 'item_no', 'comment_id', 'uid')]),
        ),
        migrations.AlterUniqueTogether(
            name='itemtypes',
            unique_together=set([('name', 'service')]),
        ),
        migrations.AlterUniqueTogether(
            name='itemsbulcainfo',
            unique_together=set([('feed_id', 'item_no')]),
        ),
        migrations.AlterUniqueTogether(
            name='friendgroupmembercounter',
            unique_together=set([('person_id', 'fgroup_id', 'mutually', 'hide_unwanted', 'direction')]),
        ),
        migrations.AlterUniqueTogether(
            name='entryxmlcontent',
            unique_together=set([('feed_id', 'post_no', 'comment_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='commentsfullparents',
            unique_together=set([('parent_id', 'post_no', 'person_id', 'comment_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='comments',
            unique_together=set([('post_no', 'comment_id', 'person_id')]),
        ),
    ]
