# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2018-03-01 11:54


from django.db import migrations, transaction
from django.conf import settings


@transaction.atomic
def migrate(apps, schema_editor):
    if getattr(settings, 'IS_TESTRUN', False):
        return
    from at.aux_ import Mailing
    return Mailing.tmp_migrate_mail_settings(
        mail_settings_cls=apps.get_model('common', 'MailSettings'),
        person_cls=apps.get_model('aux_', 'Person'),
    )


@transaction.atomic
def backwards(apps, schema_editor):
    if getattr(settings, 'IS_TESTRUN', False):
        return
    MailSettings = apps.get_model('common', 'MailSettings')
    MailSettings.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('common', '0003_mailsettings'),
    ]

    operations = [
        migrations.RunPython(
            code=migrate,
            reverse_code=backwards,
        ),
    ]


