

from django.db import models

from at.common import const


class Comments(models.Model):
    person_id = models.BigIntegerField()
    author_uid = models.BigIntegerField()
    post_no = models.BigIntegerField()
    comment_id = models.IntegerField()
    parent_id = models.IntegerField()
    level = models.IntegerField()
    children_count = models.IntegerField()
    store_time = models.DateTimeField()
    item_time = models.DateTimeField()
    screened = models.IntegerField()
    deleted = models.IntegerField()
    freezed = models.IntegerField()
    comment_type = models.IntegerField()

    class Meta:
        db_table = 'Comments'
        unique_together = (('post_no', 'comment_id', 'person_id'),)


class Commentsfullparents(models.Model):
    person_id = models.BigIntegerField()
    post_no = models.IntegerField()
    parent_id = models.IntegerField()
    comment_id = models.IntegerField()
    level_diff = models.IntegerField()

    class Meta:
        db_table = 'CommentsFullParents'
        unique_together = (('parent_id', 'post_no', 'person_id', 'comment_id'),)


class Communities(models.Model):
    feed_id = models.BigIntegerField(unique=True)
    rated = models.CharField(max_length=9)
    adult = models.CharField(max_length=9)
    rating = models.IntegerField()
    name = models.CharField(primary_key=True, max_length=255)
    rubric_id = models.IntegerField(blank=True, null=True)
    min_qu_for_posting = models.IntegerField()
    no_user_tags = models.IntegerField()

    class Meta:
        db_table = 'Communities'


class Communitiesrubrics(models.Model):
    rubric_id = models.AutoField(primary_key=True)
    name_ru = models.CharField(max_length=255, blank=True, null=True)
    name_en = models.CharField(max_length=255, blank=True, null=True)
    hidden = models.IntegerField()
    metarubric = models.CharField(max_length=6, blank=True, null=True)

    class Meta:
        db_table = 'CommunitiesRubrics'


class Communitiessequence(models.Model):
    feed_id = models.BigAutoField(primary_key=True)

    class Meta:
        db_table = 'CommunitiesSequence'


class Communitiesstat(models.Model):
    feed_id = models.BigIntegerField(primary_key=True)
    members_count = models.IntegerField(blank=True, null=True)
    posts_count = models.IntegerField(blank=True, null=True)
    last_comment_time = models.DateTimeField()
    last_post_time = models.DateTimeField()
    last_month_posts = models.IntegerField(blank=True, null=True)
    last_month_comments = models.IntegerField(blank=True, null=True)
    commentator_count = models.IntegerField(blank=True, null=True)

    class Meta:
        db_table = 'CommunitiesStat'


class Entryxmlcontent(models.Model):
    feed_id = models.BigIntegerField()
    post_no = models.BigIntegerField()
    comment_id = models.IntegerField()
    xml = models.TextField(blank=True, null=True)
    wf_version = models.CharField(max_length=10, blank=True, null=True)

    class Meta:
        db_table = 'EntryXmlContent'
        unique_together = (('feed_id', 'post_no', 'comment_id'),)


class Fgmcountersupdatequery(models.Model):
    id = models.BigAutoField(primary_key=True)
    person_id = models.BigIntegerField(unique=True)
    total = models.IntegerField()

    class Meta:
        db_table = 'FGMCountersUpdateQuery'


class Friendgroupmembercounter(models.Model):
    person_id = models.BigIntegerField()
    fgroup_id = models.IntegerField()
    mutually = models.IntegerField()
    hide_unwanted = models.IntegerField()
    direction = models.CharField(max_length=8)
    count = models.IntegerField()

    class Meta:
        db_table = 'FriendGroupMemberCounter'
        unique_together = (('person_id', 'fgroup_id', 'mutually', 'hide_unwanted', 'direction'),)


class Itemtypes(models.Model):
    name = models.CharField(max_length=255)
    service = models.CharField(max_length=255)
    group_id = models.IntegerField(blank=True, null=True)
    exportable = models.CharField(max_length=9)

    class Meta:
        db_table = 'ItemTypes'
        unique_together = (('name', 'service'),)


class Itemsbulcaincrementer(models.Model):
    feed_id = models.BigIntegerField(primary_key=True)
    last_item_no = models.BigIntegerField()

    class Meta:
        db_table = 'ItemsBulcaIncrementer'


class Itemsbulcainfo(models.Model):
    feed_id = models.BigIntegerField()
    item_no = models.BigIntegerField()
    bulca_unit_id = models.IntegerField()
    bulca_item_no = models.BigIntegerField()

    class Meta:
        db_table = 'ItemsBulcaInfo'
        unique_together = (('feed_id', 'item_no'),)


class Likes(models.Model):
    feed_id = models.BigIntegerField()
    item_no = models.BigIntegerField()
    comment_id = models.BigIntegerField()
    uid = models.BigIntegerField()
    title = models.CharField(max_length=255)
    url = models.CharField(max_length=255)
    timestamp = models.DateTimeField()
    value = models.IntegerField()

    class Meta:
        db_table = 'Likes'
        unique_together = (('feed_id', 'item_no', 'comment_id', 'uid'),)


class Longjobs(models.Model):
    person_id = models.BigIntegerField(primary_key=True)
    job_name = models.CharField(max_length=255)
    start_time = models.BigIntegerField()

    class Meta:
        db_table = 'LongJobs'


class Mailkeys(models.Model):
    person_id = models.BigIntegerField(primary_key=True)
    mail_key = models.CharField(max_length=255, blank=True, null=True)

    class Meta:
        db_table = 'MailKeys'


class MailSettings(models.Model):
    FIELDS = const.NOTIFICATION_FIELDS

    person = models.OneToOneField(
        'aux_.Person',
        on_delete=models.CASCADE,
        related_name='mail_settings',
    )
    comment_mode = models.CharField(
        choices=const.COMMENT_MODES.CHOICES,
        default=FIELDS.DEFAULTS[FIELDS.COMMENT_MODE],
        max_length=1,
    )
    digest_mode = models.CharField(
        choices=const.DIGEST_MODES.CHOICES,
        default=FIELDS.DEFAULTS[FIELDS.DIGEST_MODE],
        max_length=1,
    )
    notify_summons = models.BooleanField(default=True)
    notify_invites = models.BooleanField(default=True)
    notify_self = models.BooleanField(default=False)
    notify_moderation = models.BooleanField(default=True)

    class Meta:
        db_table = 'MailSettings'


class Postaccesses(models.Model):
    feed_id = models.BigIntegerField()
    post_no = models.IntegerField()
    fgroup_id = models.SmallIntegerField()
    deleted = models.IntegerField()

    class Meta:
        db_table = 'PostAccesses'


class Postcategories(models.Model):
    feed_id = models.BigIntegerField()
    post_no = models.BigIntegerField()
    cat_id = models.BigIntegerField()
    deleted = models.IntegerField()

    class Meta:
        db_table = 'PostCategories'
        unique_together = (('feed_id', 'post_no', 'cat_id'),)


class Postcategory(models.Model):
    person_id = models.BigIntegerField()
    id = models.BigAutoField(primary_key=True)
    title_tag = models.CharField(max_length=100)

    class Meta:
        db_table = 'PostCategory'
        unique_together = (('id', 'person_id'), ('person_id', 'title_tag'),)


class Poststoredata(models.Model):
    feed_id = models.BigIntegerField()
    item_no = models.BigIntegerField()
    link_md5 = models.CharField(max_length=16)

    class Meta:
        db_table = 'PostStoreData'
        unique_together = (('feed_id', 'link_md5'),)


class Posts(models.Model):
    person_id = models.BigIntegerField()
    author_uid = models.BigIntegerField(blank=True, null=True)
    post_no = models.BigIntegerField()
    store_time = models.DateTimeField()
    store_time_month_year = models.DateField()
    item_time = models.DateTimeField()
    post_type = models.IntegerField()
    deleted = models.IntegerField(default=0)
    public = models.IntegerField(default=1)
    store_time_usec = models.BigIntegerField()
    access_type = models.IntegerField(default=1)
    is_imported = models.IntegerField(default=1)
    deleted_manually = models.IntegerField(default=0)
    last_updated = models.DateTimeField()
    children_count = models.SmallIntegerField()
    last_comment_id = models.IntegerField(blank=True, null=True)
    screened = models.IntegerField(default=0)
    freezed = models.IntegerField(default=0)
    last_author_uid = models.BigIntegerField(blank=True, null=True)
    rubric_id = models.SmallIntegerField()
    score = models.FloatField(default=0)
    store_time_most_interesting_usec = models.BigIntegerField(blank=True, null=True)
    store_time_interesting_usec = models.BigIntegerField(blank=True, null=True)
    popular_category = models.SmallIntegerField()
    access_group = models.IntegerField(blank=True, null=True)
    on_moderation = models.IntegerField(default=0)
    pinned_after = models.BigIntegerField(blank=True, null=True)

    class Meta:
        db_table = 'Posts'
        unique_together = (('post_no', 'person_id'),)


class Profile(models.Model):
    feed_id = models.BigIntegerField()
    category = models.CharField(max_length=30)
    name = models.CharField(max_length=30)
    value = models.CharField(max_length=20000)
    content_type = models.CharField(max_length=4)

    class Meta:
        db_table = 'Profile'


class Readgroupmember(models.Model):
    uid = models.BigIntegerField()
    rgroup_id = models.IntegerField()
    type = models.CharField(max_length=2)
    person_id = models.BigIntegerField()
    cat_id = models.IntegerField()
    in_work = models.IntegerField(blank=True, null=True)
    hidden = models.IntegerField()

    class Meta:
        db_table = 'ReadGroupMember'
        unique_together = (('uid', 'rgroup_id', 'type', 'person_id', 'cat_id'),)


class Recentactionscounter(models.Model):
    person_id = models.BigIntegerField()
    type = models.CharField(max_length=17)
    count = models.IntegerField()
    answered = models.SmallIntegerField()

    class Meta:
        db_table = 'RecentActionsCounter'
        unique_together = (('person_id', 'type', 'answered'),)


class Subscriptions(models.Model):
    uid = models.BigIntegerField()
    feed_id = models.BigIntegerField()
    item_no = models.BigIntegerField()
    with_comments = models.IntegerField()
    mode = models.CharField(max_length=6)

    class Meta:
        db_table = 'Subscriptions'
        unique_together = (('uid', 'feed_id', 'item_no'),)


class Timeguard(models.Model):
    func = models.CharField(max_length=255)
    time = models.DateTimeField()
    host = models.CharField(max_length=100, blank=True, null=True)

    class Meta:
        db_table = 'TimeGuard'
        unique_together = (('func', 'time'),)


class Trackbacks(models.Model):
    person_id = models.BigIntegerField()
    post_no = models.IntegerField()
    comment_id = models.IntegerField()
    trackback_person_id = models.BigIntegerField()
    trackback_post_no = models.IntegerField()

    class Meta:
        db_table = 'Trackbacks'
        unique_together = (('person_id', 'post_no', 'comment_id'),)


class Unwantedpersons(models.Model):
    person_id = models.BigIntegerField()
    unwanted_feed_id = models.BigIntegerField()
    add_date = models.DateTimeField(blank=True, null=True)

    class Meta:
        db_table = 'UnwantedPersons'
        unique_together = (('person_id', 'unwanted_feed_id'),)


class Upscaleroles(models.Model):
    original_fgroup_id = models.IntegerField()
    upscaled_fgroup_id = models.IntegerField()

    class Meta:
        db_table = 'UpscaleRoles'
        unique_together = (('original_fgroup_id', 'upscaled_fgroup_id'),)


class Userscommentsstatistic(models.Model):
    count = models.BigIntegerField()
    author_id = models.BigIntegerField()
    type = models.IntegerField()

    class Meta:
        db_table = 'UsersCommentsStatistic'
        unique_together = (('author_id', 'type'),)


class Userspostsstatistic(models.Model):
    count = models.BigIntegerField()
    author_id = models.BigIntegerField()
    type = models.IntegerField()

    class Meta:
        db_table = 'UsersPostsStatistic'
        unique_together = (('author_id', 'type'),)


class Usersrelationsstatistic(models.Model):
    count = models.BigIntegerField()
    author_id = models.BigIntegerField()
    type = models.IntegerField()

    class Meta:
        db_table = 'UsersRelationsStatistic'
        unique_together = (('author_id', 'type'),)


class Votes(models.Model):
    poll_id = models.CharField(max_length=55)
    uid = models.BigIntegerField()
    vote = models.SmallIntegerField()
    timestamp = models.DateTimeField()

    class Meta:
        db_table = 'Votes'


class Widgetnames(models.Model):
    widget_id = models.AutoField(primary_key=True)
    name = models.CharField(unique=True, max_length=50)
    enabled = models.IntegerField(blank=True, null=True)

    class Meta:
        db_table = 'WidgetNames'


class Widgetsettings(models.Model):
    person_id = models.BigIntegerField()
    widget_id = models.IntegerField()
    enabled = models.IntegerField(blank=True, null=True)

    class Meta:
        db_table = 'WidgetSettings'
        unique_together = (('person_id', 'widget_id'),)


class Bday(models.Model):
    person_id = models.BigIntegerField(primary_key=True)
    bday = models.CharField(max_length=5, blank=True, null=True)

    class Meta:
        db_table = 'bday'

