# coding: utf-8




class AuthInfo(object):

    def __init__(
        self,
        uid=None,
        login=None,
        session_id=None,
        oauth_token=None,
        user_ticket=None
    ):
        self.uid = uid
        if isinstance(login, bytes):
            login = login.decode('utf-8')
        self.login = login
        self.session_id = session_id
        self.oauth_token = oauth_token
        self.user_ticket = user_ticket

    def __repr__(self):
        return '<%s: %s|%s>' % (
            self.__class__.__name__,
            self.login,
            self.uid,
        )

    def __str__(self):
        return str(self.__repr__())
