# coding: utf-8



from django.conf import settings

from ids.utils import https


class Resizer(object):
    def __init__(self, url):
        self.base_url = url

    def resize(self, url, width, height=None):
        params = {'url': url, 'width': width}
        if height:
            params['height'] = height

        session = https.get_secure_session()
        response = session.get(self.base_url + '/genurl', params=params)
        if response.ok:
            return response.content
resizer = Resizer(settings.RESIZER_URL)


def get_resizer():
    return resizer
