#!/usr/bin/env python
# -*- coding: utf-8 -*-

# $Id: richtrace.py 16668 2008-12-24 15:15:23Z theigel $

# Idea and implementation borrowed from Python Cookbook, ch.14.5

import sys
import traceback
import logging
import uuid


class LazyString(object):
    def __init__(self, function):
        self._f = function
    def __str__(self):
        return str(self._f())


def extract_rich_info(toplimit = None, lowlimit = None):    
    """
    Return tuple(a, b), where:
      a - usual formatted traceback
      b - some object. str(b) is listing of all the local variables in each frame
    """

    formatted_traceback = traceback.format_exc( ).decode('utf-8', 'ignore')

    def _get_stack():
        tb = sys.exc_info( )[2]

        while 1:
            if not tb.tb_next:
                break
            tb = tb.tb_next

        stack = []
        f = tb.tb_frame

        while f:
            stack.append(f)
            f = f.f_back

        stack.reverse( )

        topstack = []
        if toplimit:
            topstack, stack = stack[:toplimit], stack[toplimit:]

        lowstack = []
        if lowlimit:
            stack, lowstack = stack[:-lowlimit], stack[-lowlimit:]

        if stack and not(toplimit == None and lowlimit == None):
            stack = [len(stack)]
        stack = topstack + stack + lowstack

        result = "Locals by frame, innermost last\n"

        for frame in stack:

            if type(frame) is int:
                result += "\n(skipped %d frame%s)\n" % (frame, frame > 1 and 's' or '')
                continue

            result += "\nFrame %s in %s at line %s:\n" % (frame.f_code.co_name, frame.f_code.co_filename, frame.f_lineno)

            for key, value in list(frame.f_locals.items( )):
                result += "\t%20s = " % key

                # We have to be VERY careful not to cause a new error in our error
                # printer! Calling str( ) on an unknown object could cause an
                # error we don't want, so we must use try/except to catch it --
                # we can't stop it from happening, but we can and should
                # stop it from propagating if it does happen!
                try:
                    #print value, type(value)
                    if isinstance(value, str):
                        result += "u'%s'" % value
                    elif isinstance(value, str):
                        result += "'%s'" % value.decode('utf8')
                    else:
                        result += str(value)
                except:
                    result += "<unprintable '%s' object>" % type(value).__name__

                result += '\n'
        return result

    return (formatted_traceback, LazyString(_get_stack))
    #return (formatted_traceback, _get_stack())
    

def format_exc_rich(toplimit=None, lowlimit=None):
    """
    Format the usual traceback information, followed by a
    listing of all the local variables in each frame.
    """
    return
    formatted_exception, lazy_string = extract_rich_info(toplimit, lowlimit)
    return "%s%s" % (formatted_exception, lazy_string)

def print_exc_rich(toplimit=None, lowlimit=None):
    """
    Print the usual traceback information, followed by a
    listing of all the local variables in each frame.
    """
    return
    print(format_exc_rich(toplimit, lowlimit))

_log_exception_logger = logging.getLogger ("utils.log_exception")
_log_exception_traceback_logger = logging.getLogger ("utils.log_exception.traceback")
def log_exc_rich(toplimit = None, lowlimit = None, level = logging.ERROR):
    return
    formatted_exception, lazy_string = extract_rich_info(toplimit, lowlimit)
    unique_identifier = str(uuid.uuid1())
    
    _log_exception_logger.log(level, "[%s] %s" % (unique_identifier, formatted_exception))
    try:
        _log_exception_traceback_logger.log(level, "[%s] %s" % (unique_identifier, lazy_string))
    except:
        _log_exception_logger.error(traceback.format_exc())

if __name__ == "__main__":
    def deco(func):
        def wrapper(*args, **kwargs):
            return func(*args, **kwargs)
        return wrapper

    @deco
    def b():
        a = 10
        b = 20
        c = "Превед"
        e = "Медвед"
        d = type(c)
        print(a/(b-b)) # превед, медвед

    def a2():
        b()

    @deco
    def a():
        a2()

    try:
        a()
    except:
        print_exc_rich(toplimit=2, lowlimit=2)

# vi: ai sw=4 ts=4 expandtab
# vim: et ts=4 sts=4 sw=4
