# *-* coding: utf-8 *-*
"""Бекпорты из requests.2.3 для корректной работы startrek-python-client"""
import requests


def add_verify(func):
    
    def wrapper(*args, **kwargs):
        kwargs['verify'] = ('/etc/ssl/certs/ca-certificates.crt')
        return LinksWrapper(func(*args, **kwargs))

    return wrapper


def parse_header_links(value):
    """Return a dict of parsed link headers proxies.

    i.e. Link: <http:/.../front.jpeg>; rel=front; type="image/jpeg",<http://.../back.jpeg>; rel=back;type="image/jpeg"
    
    backport from requests 2.3.0
    """

    links = []

    replace_chars = " '\""

    for val in value.split(","):
        try:
            url, params = val.split(";", 1)
        except ValueError:
            url, params = val, ''

        link = {}

        link["url"] = url.strip("<> '\"")

        for param in params.split(";"):
            try:
                key, value = param.split("=")
            except ValueError:
                break

            link[key.strip(replace_chars)] = value.strip(replace_chars)

        links.append(link)

    return links


class LinksWrapper(object):
    """Обертка вокруг requests.Response, добавляет links."""

    def __init__(self, response):
        self.response = response

    @property
    def links(self):
        header = self.headers.get('link')
        l = {}
        if header:
            links = parse_header_links(header)
            for link in links:
                key = link.get('rel') or link.get('url')
                l[key] = link
        return l

    def __getattr__(self, name):
        return getattr(self.response, name)


class CABundleSession(object):
    """Обертка вокруг requests.Session, чтобы принудительно использовать
    яндексовское хранилище сертификатов"""

    def __init__(self):
        self.session = requests.Session()
        self.headers = self.session.headers
        self.verify_methods = ['post', 'get', 'delete', 'put', 'patch']

    def __getattr__(self, name):
        if name in self.verify_methods:
            return self.decorate_with_verify(name)
        else:
            return getattr(self.session, name)

    def decorate_with_verify(self, name):
        try:
            # Уже закешировали декорированную версию
            return getattr(self, '_' + name)
        except AttributeError:
            method = add_verify(getattr(self.session, name))
            setattr(self, '_' + name, method)
            return method


