# coding: utf-8

from .models import *
from .backports import *
from ..tvm2_client import get_service_ticket


class Startrek(object):

    def __init__(self, user_ticket, useragent, path="https://st-api.yandex-team.ru"):
        self.session = CABundleSession()
        self.session.headers['X-Ya-Service-Ticket'] = get_service_ticket('tracker')
        self.session.headers['X-Ya-User-Ticket'] = user_ticket
        self.session.headers['Content-Type'] = 'application/json'
        self.session.headers['User-Agent'] = useragent
        self.path = path

    def get_issue(self, id):
        issue = Issue(self)
        issue.get(id)
        return issue

    def create_issue(self, data):
        issue = Issue(self)
        issue.create(data)
        return issue

    def find_issues(self, query):
        return Issue(self).get_all(query)

    def get_transition(self, issue, id):
        transition = Transition(self)
        transition.get(issue, id)
        return transition

    def get_transitions(self, id):
        return Transition(self).get_all(id)

    def get_comment(self, issue, id):
        comment = Comment(self)
        comment.get(issue, id)
        return comment

    def add_comment(self, issue, text):
        comment = Comment(self)
        comment.create(issue, text)
        return comment

    def update_comment(self, issue, id, text):
        comment = Comment(self)
        comment.update_one(issue, id, text)
        return comment

    def get_comments(self, id):
        return Comment(self).get_all(id)

    def delete_comment(self, issue, id):
        comment = Comment(self)
        comment.delete_one(issue, id)

    def get_link(self, issue, id):
        link = IssueLink(self)
        link.get(issue, id)
        return link

    def get_links(self, id):
        return IssueLink(self).get_all(id)

    def add_link(self, issue, relationship, to):
        link = IssueLink(self)
        link.create(issue, relationship, to)
        return link

    def delete_link(self, issue, id):
        link = IssueLink(self)
        link.delete_one(issue, id)

    def get_attachment(self, issue, id):
        attachment = Attachment(self)
        attachment.get(issue, id)
        return attachment

    def get_attachments(self, id):
        return Attachment(self).get_all(id)

    def upload_attachment(self, issue, file):
        attachment = Attachment(self)
        attachment.upload(issue, file)

    def delete_attachment(self, issue, id):
        attachment = Attachment(self)
        attachment.delete_one(issue, id)

    def get_queue(self, id):
        queue = Queue(self)
        queue.get(id)
        return queue

    def get_queues(self):
        return Queue(self).get_all()

    def get_statuses(self):
        return Status(self).get_all()
