<xsl:stylesheet version="1.0"
    xmlns:ya="http://at.yandex-team.ru/xsl" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    exclude-result-prefixes="ya">

    <xsl:output omit-xml-declaration="yes" encoding="utf-8"/>
    <xsl:template match="node()|@*">
        <xsl:copy>
            <xsl:apply-templates select="node()|@*"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="img/@src">
        <xsl:attribute name="src">
            <xsl:value-of select="ya:resize-image(ya:remove-hide-ref(.))"/>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="a/@href">
        <xsl:attribute name="href">
            <xsl:value-of select="ya:remove-hide-ref(.)"/>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="div[@class='wiki-p']">
        <p>
            <xsl:apply-templates select="@*|node()" />
        </p>
    </xsl:template>

    <xsl:template match="img/@width"/>
    <xsl:template match="img/@height"/>

    <xsl:template match="img">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
            <xsl:attribute name="style">
                <xsl:text>max-width: 600px; max-height: 600px; width: auto;</xsl:text>
            </xsl:attribute>
        </xsl:copy>
    </xsl:template>
    <xsl:template match="ya-jira" mode="render-ticket-name">
        <xsl:value-of select="@project"/>
        <xsl:text>-</xsl:text>
        <xsl:value-of select="@ticket"/>
    </xsl:template> 

    <xsl:template match="ya-jira[@project]">
        <a>
            <xsl:attribute name="href">
                <xsl:text>https://st.yandex-team.ru/</xsl:text>
                <xsl:apply-templates select="." mode="render-ticket-name"/>
            </xsl:attribute>
            <xsl:apply-templates select="." mode="render-ticket-name"/>
        </a>
    </xsl:template>

    <xsl:template match="ya" mode="title">
        <xsl:value-of select="ya:get-feed-title(@user, @inf)"/>
    </xsl:template>

    <xsl:template match="ya[@club]" mode="title">
        <xsl:value-of select="ya:get-feed-title(@club, false(), false())"/>
    </xsl:template>

    <xsl:template match="ya[@title]" mode="title"> 
        <xsl:value-of select="@title" />
    </xsl:template>


    <xsl:template match="ya[@club]">
        <a href="{concat('http://clubs.at.yandex-team.ru/', @club)}">
            <xsl:apply-templates select="." mode="title"/>
        </a>
    </xsl:template>

    <xsl:template match="ya[@user]"> 
        <a href="{concat('http://', @user, '.at.yandex-team.ru/')}">
            <xsl:apply-templates select="." mode="title"/>
        </a>
    </xsl:template>

    <xsl:template match="iframe|object|embed|audio|video">
        <xsl:apply-templates select="." mode="mediawarning"/>
    </xsl:template>

    <xsl:template match="ya-smile" mode="content-html">
        <xsl:value-of select="@text"/>
    </xsl:template>

    <xsl:template match="*[ya:current-language() = 'ru']" mode="mediawarning">
     <p style="font-style: italic">
         Тут должен быть видеоролик, но отобразить его невозможно. <a href="{ya:current-item-link()}">Перейдите к записи</a>, чтобы посмотреть его.
     </p>
    </xsl:template>
    <xsl:template match="*[ya:current-language() = 'en']" mode="mediawarning">
     <p style="font-style: italic">
         Here should be an embedded video, but it can't be displayed. <a href="{ya:current-item-link()}">Go to the original entry</a> to watch it.
     </p>
    </xsl:template>
    <xsl:template match="autocut-text"/>
    <xsl:template match="cut|autocut|ya-wbr">
         <xsl:apply-templates />
    </xsl:template>
</xsl:stylesheet>
