<xsl:stylesheet version="1.0"
    xmlns:ya="http://at.yandex-team.ru/xsl" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    exclude-result-prefixes="ya">

    <!-- XXX FIXME
        Не осилил сделать plaintext выдачу xslt-преобразования,
        поэтому заворачиваю всё в корневой тег root.
    -->

    <xsl:output omit-xml-declaration="yes" method="txt" encoding="utf-8"/>
    <xsl:template match="/">
        <xsl:variable name="content">
            <xsl:apply-templates/>
        </xsl:variable>
        <root>
            <xsl:value-of select="$content"/>
        </root>
    </xsl:template>


    <xsl:template match="ul/li">
        <xsl:text>* </xsl:text>
        <xsl:apply-templates />
        <xsl:text> </xsl:text>
    </xsl:template>

    <xsl:template match="ol/li" >
        <xsl:value-of select="count(preceding-sibling::li) + 1"/>
        <xsl:text>. </xsl:text>
        <xsl:apply-templates />
        <xsl:text> </xsl:text>
    </xsl:template>

    <xsl:template match="h1 | h2 | h3 | h4 | h5 | h6 | p | div | ul | ol | blockquote">
        <xsl:apply-templates />
        <xsl:value-of select="' '"/>
    </xsl:template>

    <xsl:template match="br">
        <xsl:value-of select="' '"/>
    </xsl:template>

    <xsl:template match="s | del" />

    <xsl:template match="text()" name="insertBreaks">
        <xsl:copy-of select="translate(., '&#x20;&#x9;&#xD;&#xA;', '     ')"/>
     </xsl:template>


</xsl:stylesheet>
