# coding=utf-8

from tvm2 import TVM2
from tvmauth import BlackboxTvmId as BlackboxClientId
from django.conf import settings


def get_tvm2_client():
    return TVM2(
        client_id=settings.YAUTH_TVM2_CLIENT_ID,
        secret=settings.YAUTH_TVM2_SECRET,
        blackbox_client=BlackboxClientId.ProdYateam,
        destinations=settings.TVM2_DESTINATIONS,
        allowed_clients=settings.YAUTH_TVM2_ALLOWED_CLIENT_IDS,
    )


def get_service_ticket(service):
    tvm2_client = get_tvm2_client()
    client_id = settings.TVM2_CLIENTS[service]
    service_tickets = tvm2_client.get_service_tickets(client_id)
    return service_tickets[client_id]
