# coding: utf-8

import emoji
from ids.registry import registry

VERSION = '3'
TIMEOUT = 10

_repo = None


def get_repository():
    global _repo
    if _repo is None:
        _repo = registry.get_repository(
            'formatter',
            'formatter',
            user_agent='at',
            timeout=TIMEOUT,
        )
    return _repo


def convert_to_html(wiki_text, version=VERSION):
    repo = get_repository()
    wiki_text = emoji.demojize(wiki_text)
    html = repo.convert_to_html(
        wiki_text=wiki_text,
        config='at',
        version=version,
    )
    return emoji.emojize(html, variant="emoji_type")
