# *-* coding: utf-8 *-*

import os
from threading import Lock
from functools import wraps

from lxml import etree as ET

from django.conf import settings

from at.common.Singleton import Singleton


XSLT_PATH = settings.XSLT_PATH

file_lock = Lock()


class XSLTransformer(Singleton):

    TEMPLATES = {}
    namespace = 'http://at.yandex-team.ru/xsl'
    _ns = ET.FunctionNamespace(namespace)
    _ns.prefix = 'ya'

    @classmethod
    def register_function(self, key, func_obj):
        self._ns[key] = func_obj

    def get_template(self, template_name):
        if not template_name.endswith('.xsl'):
            template_name = ''.join((template_name, '.xsl'))
        with file_lock:
            if template_name not in self.TEMPLATES:
                self.TEMPLATES[template_name] = ET.XSLT(
                    ET.parse(
                        os.path.join(XSLT_PATH, template_name)
                    )
                )
        return self.TEMPLATES[template_name]

    def apply_template(self, xml, template_name, result_as_string=False):
        if isinstance(xml, str):
            xml = ET.fromstring(xml)
        xslt = self.get_template(template_name)
        result = xslt(xml)
        if result_as_string:
            return ET.tounicode(result)
        else:
            return result


def xslt_custom_function(func_name, silent=True):
    def wrapper(func):
        @wraps(func)
        def inner_wrapper(context, *args, **kwargs):
            return func(*args, **kwargs)
        XSLTransformer.register_function(func_name, inner_wrapper)
        return inner_wrapper
    return wrapper

