#!/usr/bin/env python


import os
import sys

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "at.settings")

QLOUD_ENVIRONMENT = os.environ.get('QLOUD_ENVIRONMENT')
if 'YENV_TYPE' not in os.environ and QLOUD_ENVIRONMENT is not None:
    if '-' in QLOUD_ENVIRONMENT:
        # for env names like testing-one and production-something
        yenv_type = QLOUD_ENVIRONMENT.split('-')[0]
    else:
        yenv_type = QLOUD_ENVIRONMENT
    os.environ['YENV_TYPE'] = yenv_type
os.environ['YENV_NAME'] = 'intranet'


def django_main():
    from django.core.management import execute_from_command_line
    execute_from_command_line(sys.argv)


def celery_main():
    from celery.__main__ import main
    return main()


if __name__ == "__main__":
    django_main()
