# coding: utf-8

import time
import threading
import pickle as marshal


def dumps(fields):
    return '.'.join([
            str(f) if type(f) in (int, int) else
                    'e'+(marshal.dumps(f).encode('base64').replace('/', '-').strip())
            for f in fields
            ]).replace('\n', '')


def loads(s):
    res = []
    for f in s.split('.'):
        assert f, 'empty field in filename: %s' % s
        try:
            if f[0] == 'e':
                res.append(marshal.loads(f[1:].replace('-', '/').decode('base64')))
            else:
                res.append(int(f))
        except Exception as msg:
            raise AssertionError('Cant parse field value %s: %s'\
                    % (f, msg))
    return res


class Event(object):
    field_names = []

    def __init__(self, *args, **kwargs):
        self.fields = {}
        for name, value in zip(self.field_names, args):
            self.fields[name] = value

        for name, value in list(kwargs.items()):
            if name not in self.field_names:
                raise RuntimeError('wrong field_name %s for Event' % name)
            if name in self.fields:
                raise  RuntimeError('duplicate fiend_name %s for Event' % name)
            self.fields[name] = value

    def __str__(self):
        d = ', '.join(['%s=%s' % (k, self.fields[k]) for k in self.field_names])
        return '%s [%s]' % (self.__class__, d)

    def short(self):
        return '.'.join([str(self.fields[f]) for f in self.field_names])

    def tuple(self):
        return tuple(self.fields[f] for f in self.field_names)
