# -*- coding: utf-8 -*-

import logging
import types

from django.conf import settings
from ids.utils import https
import requests

from at.pump.Query import Handler, Event
from at.common.tvm2_client import get_service_ticket

_log = logging.getLogger(__name__)


class ISearchHandler(Handler):
    """Inform Intranet search about new posts and replies."""

    class Event(Event):
        field_names = ['feed_id', 'item_no', 'deleted']

    def action(self, event):
        feed_id, item_no, deleted = event

        json_data = {
            'id': 'urn:ya.ru:post/%d/%d' % (feed_id, item_no)
        }

        _log.debug('Sending json: %s', json_data)
        session = https.get_secure_session()
        response = session.post(
            url=settings.ISEARCH_PUSH_URL,
            json=json_data,
            timeout=60,
            headers={'X-Ya-Service-Ticket': get_service_ticket('search')},
        )
        if response.status_code != requests.codes.ok:
            _log.error('Failed to index post %s.%s: code %s, response %s' % (
                feed_id, item_no, response.status_code, response.content))
            return

        return event.get_human_repr()

names = list(locals().keys())
__all__ = [name for name, obj in locals().items() if isinstance(obj, type) and issubclass(obj,
                                                 (Event, Handler))]
